﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_TimeSpan.h>
#include <nnt/lcs/testLcs_TestApplications.h>

//! 接続待ちのタイムアウト時間です。
const nn::TimeSpan JoinTimeout = nn::TimeSpan::FromSeconds(5);

//! スキャン待ちのタイムアウト時間です。
const nn::TimeSpan ScanTimeout = nn::TimeSpan::FromSeconds(4);

//! 状態変化待ちのタイムアウト時間です。
const nn::TimeSpan StateChangeTimeout = nn::TimeSpan::FromSeconds(2);

//! 配信完了待ちのタイムアウト時間です。最悪時はこの時間内に 7 台が受信を完了する必要があります。
const nn::TimeSpan ShareTimeout = nn::TimeSpan::FromSeconds(300);

//! フライトモード状態変化待ちのタイムアウト時間です。
const nn::TimeSpan WirelessSwitchChangeTimeout = nn::TimeSpan::FromSeconds(1);

//! コンテンツの最大サイズです。
const size_t ContentSizeMax = 128 * 1024U * 1024U;
