﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/lcs.h>
#include <nn/lcs/lcs_DebugApi.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/socket.h>
#include <nnt.h>
#include <nnt/lcs/testLcs_Utility.h>
#include <nnt/ldn/testLdn_HtcsSynchronization.h>
#include <nnt/ldn/testLdn_NifmUtility.h>
#include <nnt/ldn/testLdn_Utility.h>
#include <nnt/result/testResult_Assert.h>
#include "Precondition.h"

namespace
{
    // テストを実行するヘルパです。
    nnt::lcs::TestHelper* g_pHelper;

    // Socket の初期化用バッファです。
    nn::socket::ConfigDefaultWithMemory g_SocketConfig;

} // namespace <unnamed>

//
// 全端末が最新の場合、何もせずすぐにパッチ配信が成功します。
//
TEST(PatchShare, EveryoneIsLatest)
{
    nnt::lcs::Precondition cond;
    cond = GetPrecondition(
        "PatchShare", "EveryoneIsLatest",
        nnt::lcs::Application::PatchShare01);
    g_pHelper->RunTest(cond, "PatchShare.EveryoneIsLatest1", 2);
    cond = GetPrecondition(
        "PatchShare", "EveryoneIsLatest",
        nnt::lcs::Application::PatchShare08);
    g_pHelper->RunTest(cond, "PatchShare.EveryoneIsLatest2", 2);
}

//
// ホストが最新の場合、ホストが送信者になります。
//
TEST(PatchShare, HostIsLatest)
{
    nnt::lcs::Precondition cond;
    cond = GetPrecondition(
        "PatchShare", "HostIsLatest",
        nnt::lcs::Application::PatchShare05);
    g_pHelper->RunTest(cond, "PatchShare.HostIsLatest1", 2);
    cond = GetPrecondition(
        "PatchShare", "HostIsLatest",
        nnt::lcs::Application::PatchShare11);
    g_pHelper->RunTest(cond, "PatchShare.HostIsLatest2", 2);
    cond = GetPrecondition(
        "PatchShare", "HostIsLatest",
        nnt::lcs::Application::PatchShare14);
    g_pHelper->RunTest(cond, "PatchShare.HostIsLatest3", 2);
}

//
// 先頭のクライアントだけが最新の場合、そのクライアントが送信者になります。
//
TEST(PatchShare, FirstClientIsLatest)
{
    nnt::lcs::Precondition cond;
    cond = GetPrecondition(
        "PatchShare", "FirstClientIsLatest",
        nnt::lcs::Application::PatchShare03);
    g_pHelper->RunTest(cond, "PatchShare.FirstClientIsLatest1", 2);
    cond = GetPrecondition(
        "PatchShare", "FirstClientIsLatest",
        nnt::lcs::Application::PatchShare10);
    g_pHelper->RunTest(cond, "PatchShare.FirstClientIsLatest2", 2);
    cond = GetPrecondition(
        "PatchShare", "FirstClientIsLatest",
        nnt::lcs::Application::PatchShare13);
    g_pHelper->RunTest(cond, "PatchShare.FirstClientIsLatest3", 2);
}

//
// 2 番目以降のクライアントが最新の場合、そのクライアントが送信者になります。
//
TEST(PatchShare, SomeClientsAreLatest)
{
    nnt::lcs::Precondition cond;
    cond = GetPrecondition(
        "PatchShare", "SomeClientsAreLatest",
        nnt::lcs::Application::PatchShare02);
    g_pHelper->RunTest(cond, "PatchShare.SomeClientsAreLatest", 3);
    cond = GetPrecondition(
        "PatchShare", "SomeClientsAreLatest",
        nnt::lcs::Application::PatchShare09);
    g_pHelper->RunTest(cond, "PatchShare.SomeClientsAreLatest", 3);
    cond = GetPrecondition(
        "PatchShare", "SomeClientsAreLatest",
        nnt::lcs::Application::PatchShare12);
    g_pHelper->RunTest(cond, "PatchShare.SomeClientsAreLatest", 3);
}

//
// ホストと先頭のクライアントが最新の場合、ホストが送信者になります。
//
TEST(PatchShare, HostAndFirstClientAreLatest)
{
    nnt::lcs::Precondition cond;
    cond = GetPrecondition(
        "PatchShare", "HostAndFirstClientAreLatest",
        nnt::lcs::Application::PatchShare07);
    g_pHelper->RunTest(cond, "PatchShare.HostAndFirstClientAreLatest", 3);
}

//
// ホストと先頭以外のクライアントが最新の場合、ホストが送信者になります。
//
TEST(PatchShare, HostAndSomeClientsAreLatest)
{
    nnt::lcs::Precondition cond;
    cond = GetPrecondition(
        "PatchShare", "HostAndSomeClientsAreLatest",
        nnt::lcs::Application::PatchShare06);
    g_pHelper->RunTest(cond, "PatchShare.HostAndSomeClientsAreLatest", 3);
}

//
// 全クライアントが最新の場合、先頭のクライアントが送信者になります。
//
TEST(PatchShare, AllClientsAreLatest)
{
    nnt::lcs::Precondition cond;
    cond = GetPrecondition(
        "PatchShare", "AllClientsAreLatest",
        nnt::lcs::Application::PatchShare04);
    g_pHelper->RunTest(cond, "PatchShare.AllClientsAreLatest", 3);
}

//
// テストのエントリポイントです。
//
extern "C" void nnMain()
{
    // コマンドライン引数に関する設定です。
    nnt::lcs::CommandLineParserSetting setting = { };
    setting.flag = static_cast<nn::Bit32>(
        nnt::lcs::CommandLineOptionFlag_NodeCount |
        nnt::lcs::CommandLineOptionFlag_NodeIndex |
        nnt::lcs::CommandLineOptionFlag_SceneId);
    setting.nodeCountMin = 2;
    setting.nodeCountMax = nnt::ldn::SynchronizationClientCountMax;

    // コマンドライン引数を解析します。
    nnt::lcs::TestConfig config;
    int argc = nn::os::GetHostArgc();
    char **argv = nn::os::GetHostArgv();
    ::testing::InitGoogleTest(&argc, argv);
    nnt::lcs::Parse(&config, setting, argc, argv);

    // socket ライブラリと ns ライブラリを初期化しておきます。
    nn::socket::Initialize(g_SocketConfig);
    nnt::lcs::NsInitializer nsInitiailzer;

    // テストの準備です。
    nnt::lcs::Setup(config.sceneId);

    // テストを実行します。
    g_pHelper = new nnt::lcs::TestHelper(config, "nnt::lcs::IntegrationPatchShare");
    int exitCode = RUN_ALL_TESTS();
    delete g_pHelper;

    // 終了処理です。
    nn::socket::Finalize();
    nnt::Exit(exitCode);
}
