﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/lcs.h>
#include <nn/lcs/lcs_DebugApi.h>
#include <nn/lcs/lcs_PrivateDebugApi.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/socket.h>
#include <nnt.h>
#include <nnt/lcs/testLcs_Utility.h>
#include <nnt/ldn/testLdn_HtcsSynchronization.h>
#include <nnt/ldn/testLdn_NifmUtility.h>
#include <nnt/ldn/testLdn_Utility.h>
#include <nnt/result/testResult_Assert.h>
#include "Precondition.h"

namespace
{
    // テストを実行するヘルパです。
    nnt::lcs::TestHelper* g_pHelper;

    // Socket の初期化用バッファです。
    nn::socket::ConfigDefaultWithMemory g_SocketConfig;

} // namespace <unnamed>

//
// ホストのシステムが最新の場合、ホストがマスターになります。
//
TEST(HostMigration, HostHasLatestSystem)
{
    nnt::lcs::Precondition cond;
    cond = GetPrecondition(
        "HostMigration", "HostHasLatestSystem",
        nnt::lcs::Application::HostMigration01);
    g_pHelper->RunTest(cond, "HostMigration.HostHasLatestSystem1", 3);
    cond = GetPrecondition(
        "HostMigration", "HostHasLatestSystem",
        nnt::lcs::Application::HostMigration02);
    g_pHelper->RunTest(cond, "HostMigration.HostHasLatestSystem2", 3);
    cond = GetPrecondition(
        "HostMigration", "HostHasLatestSystem",
        nnt::lcs::Application::HostMigration03);
    g_pHelper->RunTest(cond, "HostMigration.HostHasLatestSystem3", 3);
}

//
// ホストと先頭のクライアントのシステムが最新の場合、ホストがマスターになります。
//
TEST(HostMigration, HostAndFirstClientHaveLatestSystem)
{
    nnt::lcs::Precondition cond;
    cond = GetPrecondition(
        "HostMigration", "HostAndFirstClientHaveLatestSystem",
        nnt::lcs::Application::HostMigration01);
    g_pHelper->RunTest(cond, "HostMigration.HostAndFirstClientHaveLatestSystem1", 3);
    cond = GetPrecondition(
        "HostMigration", "HostAndFirstClientHaveLatestSystem",
        nnt::lcs::Application::HostMigration02);
    g_pHelper->RunTest(cond, "HostMigration.HostAndFirstClientHaveLatestSystem2", 3);
    cond = GetPrecondition(
        "HostMigration", "HostAndFirstClientHaveLatestSystem",
        nnt::lcs::Application::HostMigration03);
    g_pHelper->RunTest(cond, "HostMigration.HostAndFirstClientHaveLatestSystem3", 3);
}

//
// クライアントのシステムが最新の場合、そのクライアントがマスターになります。
//
TEST(HostMigration, FirstClientHasLatestSystem)
{
    nnt::lcs::Precondition cond;
    cond = GetPrecondition(
        "HostMigration", "FirstClientHasLatestSystem",
        nnt::lcs::Application::HostMigration01);
    g_pHelper->RunTest(cond, "HostMigration.FirstClientHasLatestSystem1", 3);
    cond = GetPrecondition(
        "HostMigration", "FirstClientHasLatestSystem",
        nnt::lcs::Application::HostMigration02);
    g_pHelper->RunTest(cond, "HostMigration.FirstClientHasLatestSystem2", 3);
    cond = GetPrecondition(
        "HostMigration", "FirstClientHasLatestSystem",
        nnt::lcs::Application::HostMigration03);
    g_pHelper->RunTest(cond, "HostMigration.FirstClientHasLatestSystem3", 3);
}

//
// 2 番目以降のクライアントのシステムが最新の場合、2 番目のクライアントがマスターになります。
//
TEST(HostMigration, SomeClientsHaveLatestSystem)
{
    nnt::lcs::Precondition cond;
    cond = GetPrecondition(
        "HostMigration", "SomeClientsHaveLatestSystem",
        nnt::lcs::Application::HostMigration01);
    g_pHelper->RunTest(cond, "HostMigration.SomeClientsHaveLatestSystem1", 3);
    cond = GetPrecondition(
        "HostMigration", "SomeClientsHaveLatestSystem",
        nnt::lcs::Application::HostMigration02);
    g_pHelper->RunTest(cond, "HostMigration.SomeClientsHaveLatestSystem2", 3);
    cond = GetPrecondition(
        "HostMigration", "SomeClientsHaveLatestSystem",
        nnt::lcs::Application::HostMigration03);
    g_pHelper->RunTest(cond, "HostMigration.SomeClientsHaveLatestSystem3", 3);
}

//
// テストのエントリポイントです。
//
extern "C" void nnMain()
{
    // コマンドライン引数に関する設定です。
    nnt::lcs::CommandLineParserSetting setting = { };
    setting.flag = static_cast<nn::Bit32>(
        nnt::lcs::CommandLineOptionFlag_NodeCount |
        nnt::lcs::CommandLineOptionFlag_NodeIndex |
        nnt::lcs::CommandLineOptionFlag_SceneId);
    setting.nodeCountMin = 2;
    setting.nodeCountMax = nnt::ldn::SynchronizationClientCountMax;

    // コマンドライン引数を解析します。
    nnt::lcs::TestConfig config;
    int argc = nn::os::GetHostArgc();
    char **argv = nn::os::GetHostArgv();
    ::testing::InitGoogleTest(&argc, argv);
    nnt::lcs::Parse(&config, setting, argc, argv);

    // socket ライブラリと ns ライブラリを初期化しておきます。
    nn::socket::Initialize(g_SocketConfig);
    nnt::lcs::NsInitializer nsInitiailzer;

    // テストの準備です。
    nnt::lcs::Setup(config.sceneId);

    // テストを実行します。
    g_pHelper = new nnt::lcs::TestHelper(config, "nnt::lcs::IntegrationHostMigration");
    int exitCode = RUN_ALL_TESTS();
    delete g_pHelper;

    // 終了処理です。
    nn::socket::Finalize();
    nnt::Exit(exitCode);
}
