﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt/lcs/testLcs_Utility.h>

void SetGamecardRemovedWithoutLaunchPrecondition(
    nnt::lcs::PreconditionSource* pSource,
    const char* test, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(applicationId);
    auto& source = *pSource;
    if (std::strcmp(test, "DownloadPatchSuccess") == 0)
    {
        source.SetApplicationVersion(2, 1, 2);
    }
    else
    {
        NN_ABORT("Unknown Test: GamecardRemovedWithoutLaunch.%s\n", test);
    }
}

void SetGamecardRemovedAfterLaunchPrecondition(
    nnt::lcs::PreconditionSource* pSource,
    const char* test, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(applicationId);
    auto& source = *pSource;
    if (std::strcmp(test, "DownloadPatchSuccess1") == 0)
    {
        source.SetApplicationVersion(3, 1, 3);
        source.SetApplicationRequiredVersion(0, 3, 0);
    }
    else if (std::strcmp(test, "DownloadPatchSuccess2") == 0)
    {
        source.SetApplicationVersion(4, 1, 4);
        source.SetApplicationRequiredVersion(0, 3, 0);
    }
    else if (std::strcmp(test, "DownloadPatchFailure1") == 0)
    {
        source.SetApplicationVersion(2, 1, 2);
        source.SetApplicationRequiredVersion(0, 3, 0);
    }
    else if (std::strcmp(test, "DownloadPatchFailure2") == 0)
    {
        source.SetApplicationVersion(1, 1, 2);
        source.SetApplicationRequiredVersion(0, 3, 0);
    }
    else
    {
        NN_ABORT("Unknown Test: GamecardRemovedAfterLaunch.%s\n", test);
    }
}

nnt::lcs::Precondition GetPrecondition(
    const char* testcase, const char* test, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_UNUSED(testcase);
    NN_UNUSED(test);
    auto source = nnt::lcs::CreateDefaultPreconditionSource();
    source.application.id = applicationId;
    if (std::strcmp(testcase, "GamecardRemovedWithoutLaunch") == 0)
    {
        SetGamecardRemovedWithoutLaunchPrecondition(&source, test, applicationId);
    }
    else if (std::strcmp(testcase, "GamecardRemovedAfterLaunch") == 0)
    {
        SetGamecardRemovedAfterLaunchPrecondition(&source, test, applicationId);
    }
    else
    {
        NN_ABORT("Unknown Testcase: %s\n", testcase);
    }
    return Calculate(source);
}

nnt::lcs::Precondition GetPrecondition(
    const char* testcase, const char* test, uint64_t applicationId) NN_NOEXCEPT
{
    nn::ncm::ApplicationId id = { applicationId };
    return GetPrecondition(testcase, test, id);
}
