﻿Param(
    [Parameter(Mandatory=$TRUE)][string] $Address,
    [Parameter(Mandatory=$TRUE)][string] $Name,
    [Parameter(Mandatory=$TRUE)][int] $Index,
    [Parameter(Mandatory=$TRUE)][string[]] $ConfigFiles
)

# スクリプトをロードします。
$SCRIPT_DIR = (Split-Path -Parent $MyInvocation.MyCommand.Path)
$LDN_SCRIPT_DIR = (Convert-Path $SCRIPT_DIR\..\..\..\Ldn\Sources\Scripts)
. $LDN_SCRIPT_DIR\Siglo\Bundle
. $SCRIPT_DIR\Manager\Contents
. $SCRIPT_DIR\Manager\Task
. $SCRIPT_DIR\Manager\Utility

# セットアップの開始を通知するログを表示します。
Write-Host "Setup Target: $($ConfigFiles) $($Name)"

# コンテンツ定義を生成します。
$Contents = (ReadContentsFromJson "$SCRIPT_DIR\Contents")

# ターゲットをセットアップします。
$ConfigPaths = $ConfigFiles | % { "$SCRIPT_DIR\Configs\$_" }
$Target = @{ Address = $Address; Name = $Name; Index = $Index }

# ターゲットをセットアップします。
SetupTarget $Target $ConfigPaths $Contents
