﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "TestVm.h"

#include <nn/nn_Abort.h>

namespace nn { namespace jit { namespace testvm {

void ResolveLabel(Program* pProgram) NN_NOEXCEPT
{
    auto& program = *pProgram;
    for (auto i = 0u; i < program.instructionCount; ++i)
    {
        auto& inst = program.instructions[i];
        if (inst.kind == InstructionKind::PushL)
        {
            for (auto j = 0u; j < program.instructionCount; ++j)
            {
                auto& inst2 = program.instructions[j];
                if (inst2.kind == InstructionKind::Label && inst2.imm == inst.imm)
                {
                    inst.kind = InstructionKind::Imm;
                    inst.imm = j - i;
                    break;
                }
            }
            NN_ABORT_UNLESS(inst.kind == InstructionKind::Imm, "no label\n");
        }
    }
}

}}}
