﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/hid/hid_ControllerSupport.h>
#include <sstream>

#include "SceneBase.h"

namespace
{
}

void SceneBase::Initialize(
    nn::hid::NpadIdType id,
    GraphicsSystem* pGraphicsSystem,
    void* pImageTransferWorkMemory)
{
    NN_ASSERT_NOT_NULL(pGraphicsSystem);
    NN_ASSERT_NOT_NULL(pImageTransferWorkMemory);

    m_NpadId = id;
    m_pGraphicsSystem = pGraphicsSystem;
    m_pImageBuffer = pImageTransferWorkMemory;

    DoInitialize();
}

void SceneBase::Finalize()
{
    DoFinalize();

    m_pGraphicsSystem = nullptr;
    m_pImageBuffer = nullptr;
}

void SceneBase::Update() NN_NOEXCEPT
{
    DoUpdate();
}

void SceneBase::Draw() NN_NOEXCEPT
{
    DoDraw();
}

int SceneBase::GetMenuIndex() const
{
    return m_MenuSelection;
}
