﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "IrSensorModeState.h"


class MomentModeState : public IrSensorModeState
{
public:
    MomentModeState(IrSensorMode* pNextProcessor, int* pMenuSelection, nn::irsensor::IrCameraHandle irCameraHandle);

    void Start() NN_OVERRIDE;
    void Update() NN_OVERRIDE;
    void Render(nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer, nn::gfx::CommandBuffer* pCommandBuffer, int index) NN_OVERRIDE;

    void Record(const RecordInfo& recordInfo, const PathInfo& pathInfo, int clusterCountMax, GraphicsSystem* pGraphicsSystem) NN_OVERRIDE;
    void Reset() NN_OVERRIDE;

    void SetViewMode(ViewMode viewMode) NN_OVERRIDE;

private:
    nn::irsensor::MomentProcessorState m_MomentProcessorState;
    nn::irsensor::MomentProcessorConfig m_MomentProcessorConfig;
    ViewMode m_ViewMode;

};
