﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/gfx.h>
#include <nnt/graphics/testGraphics_AllocatorFunction.h>

namespace nnt{ namespace eft{

    class FrameCapture
    {
    public:
        FrameCapture();
        ~FrameCapture();
        void Initialize(
            nn::gfx::Device* pDevice,
            nn::gfx::MemoryPool* pMemoryPool,
            ptrdiff_t* pMemoryPoolOffset,
            nn::gfx::MemoryPool* pMemoryPoolInvisible,
            ptrdiff_t* pMemoryPoolInvisibleOffset,
            int screenWidth,
            int screenHeight);
        void Finalize();

        /**
         * @brief 画面のキャプチャを行うコマンドを挿入します。
         */
        void PushCaptureCommand(nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::ColorTargetView* pSrcView, nn::gfx::ImageFormat srcTextureFormat);
        /**
         * @brief 画面のキャプチャを行うコマンドを挿入します。
         */
        void PushCaptureCommand(nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::Texture* pSrcTexture, nn::gfx::ImageFormat srcTextureFormat);
        /**
         * @brief キャプチャした画面を内部バッファに転送します。
         */
        void FetchCaptureResult();

        /**
         * @brief 最後にキャプチャした画像を指定したパスに png で書き出します。
         */
        void SaveToPng(const char* destPath);

    private:
        bool m_IsInitialized;

        nn::mem::StandardAllocator m_TestGraphicsStandardAllocator;
        nnt::graphics::AllocatorFunction m_TestGraphicsAllocatorFunction;

        int m_ScreenWidth;
        int m_ScreenHeight;

        nn::gfx::Device* m_pDevice;
        //nnt::eft::MemortPoolAllocator* m_pMemoryPoolAllocator;
        //nnt::eft::MemortPoolAllocator* m_pInvisibleMemPoolAllocator;
        nn::gfx::Buffer m_CaptureBuffer;
        nn::gfx::Texture m_CaptureTexture;
        nn::gfx::ImageFormat m_CaptureFormat;

        uint8_t* m_CapturedImageBuffer;
        size_t m_CapturedImageBufferSize;
    };

}}
