﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx.h>
#include <nns/gfx/gfx_PrimitiveRenderer.h>
#include <nn/hid.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/hid/hid_NpadSixAxisSensor.h>
#include <nn/irsensor.h>

#include "GraphicsSystem.h"
#include "SceneBase.h"
#include "AttachmentLogger.h"

enum IrSensorMode {
    IrSensorMode_Clustering = 0,
    IrSensorMode_ImageTransfer = 1,
    IrSensorMode_Count = 2,
};

struct Texture
{
    nn::gfx::Texture texture;
    nn::gfx::TextureView view;
    nn::gfx::DescriptorSlot descriptor;
};

struct Sampler
{
    nn::gfx::Sampler sampler;
    nn::gfx::DescriptorSlot descriptor;
};


void CreateTexture(GraphicsSystem* pGraphicsSystem, int width, int height, nn::gfx::ImageFormat format, Texture* pTexture);
void CreateSampler(GraphicsSystem* pGraphicsSystem, Sampler* pSampler);


class IrSensorModeState;

class AttachmentEvaluationView
{
public:
    NN_DISALLOW_COPY(AttachmentEvaluationView);
    NN_DISALLOW_MOVE(AttachmentEvaluationView);

public:
    AttachmentEvaluationView();
    virtual ~AttachmentEvaluationView();

public:
    enum ViewMode
    {
        ViewMode_Edit,
        ViewMode_Record,
        ViewMode_CountMax,
    };

    enum RecordMenu
    {
        RecordMenu_Camera,
        RecordMenu_AttachmentVersion,
        RecordMenu_AttachmentId,
        RecordMenu_CountMax,
    };

private:
    bool ProcessHidInput() NN_NOEXCEPT;
    void DrawRecordParameters(
        const float offsetX, const float offsetY,
        int selectIndex,
        nn::gfx::util::DebugFontTextWriter* pTextWriter);

public:
    void Initialize(nn::hid::NpadIdType id, GraphicsSystem* pGraphicsSystem, void* pImageTransferWorkMemory, AttachmentInput* pInput);
    void Finalize();
    void Update() NN_NOEXCEPT;
    void Draw(GraphicsSystem* pGraphicsSystem, nn::gfx::util::DebugFontTextWriter* pTextWriter) NN_NOEXCEPT;

    bool IsFrameCaptured() NN_NOEXCEPT;
    void CaptureFrame() NN_NOEXCEPT;

protected:
    int GetMenuIndex() const;

private:
    nn::hid::NpadIdType              m_NpadId;
    nn::hid::SixAxisSensorHandle     m_SixAxisHandles[2];
    int                              m_MenuSelection{};
    RecordMenu                       m_RecordMenuIndex;
    GraphicsSystem*                  m_pGraphicsSystem;
    void*                            m_pImageBuffer;
    nn::hid::NpadJoyDualState        m_PreviousPadState{};
    IrSensorMode                     m_CurrentProcessor{};
    IrSensorMode                     m_NextProcessor{};
    nn::irsensor::IrCameraHandle     m_IrCameraHandle{};
    IrSensorModeState*               m_ModeStates[IrSensorMode_Count];
    AttachmentInput*                 m_pAttachmentInput;
    AttachmentOutput                 m_AttachmentOutput;
    AttachmentLogger                 m_AttachmentLogger;
    ViewMode                         m_ViewMode;
    RecordInfo                       m_RecordInfo;
    int                              m_RecordFinishedCounter;
    bool                             m_IsCaptureCalled;
    bool                             m_IsCaptured;
};
