﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Thread.h>
#include <nn/err/err_ShowErrorApi.h>
#include <nn/irsensor.h>
#include <nn/irsensor/irsensor_ResultPrivate.h>
#include <nnt.h>
#include "../Common/testIrsensor_Util.h"

using namespace ::nn::irsensor;

namespace nnt { namespace irsensor {
    IrCameraHandle IrSensorTest::s_Handles[NpadIdCountMax];
    int IrSensorTest::s_HandleCount;
}}

namespace
{
// Run 直後のインターバル
const auto RunInterval = nn::TimeSpan::FromMilliSeconds(200);

class ErrorViewerTest : public ::nnt::irsensor::IrSensorTest
{
};

TEST_F(ErrorViewerTest, NeedUpdate)
{
    nn::err::ShowError(nn::irsensor::ResultIrsensorNeedUpdate());
}

TEST_F(ErrorViewerTest, HardwareError)
{
    nn::err::ShowError(nn::irsensor::ResultIrsensorHardwareError());
}

TEST_F(ErrorViewerTest, NeedCharge)
{
    nn::err::ShowError(nn::irsensor::ResultIrsensorNeedCharge());
}

TEST_F(ErrorViewerTest, NeedUpdateInSequence)
{
    for (auto j = 0; j < s_HandleCount; ++j)
    {
        const auto& handle = s_Handles[j];

        MomentProcessorConfig config;
        GetMomentProcessorDefaultConfig(&config);

        RunMomentProcessor(handle, config);

        nn::os::SleepThread(RunInterval);
        nn::err::ShowError(nn::irsensor::ResultIrsensorNeedUpdate());

        StopImageProcessor(handle);
    }
}

TEST_F(ErrorViewerTest, NeedUpdateInRetry)
{
    for (auto i = 0; i < 2; i++)
    {
        // 1度発生する場合は、stop しているので2週目も表示される
        const auto& handle = s_Handles[0];

        MomentProcessorConfig config;
        GetMomentProcessorDefaultConfig(&config);

        RunMomentProcessor(handle, config);

        nn::os::SleepThread(RunInterval);
        MomentProcessorState state;
        GetMomentProcessorState(&state, handle);

        StopImageProcessor(handle);
    }
}

} // namespace
