﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
//  nninitSetMallocRegion 動作確認テスト
//-----------------------------------------------------------------------------

#include <nn/TargetConfigs/build_Base.h>
#include <nn/TargetConfigs/build_Compiler.h>

#if defined(NN_BUILD_CONFIG_COMPILER_VC)
    // 日本語以外の環境で表示される文字コードエンコーディングに関する警告の抑制
    #pragma warning( disable : 4566 )
#endif

#include <cstdlib>
#include <cstring>

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>

extern "C" {

void nninitStartup()
{
}

//-----------------------------------------------------------------------------
//  malloc(), free(), calloc(), realloc() 関数の独自定義
//
//  ここはテストなので実際のメモリ獲得を行なう振舞いではなく、
//  malloc() 系は 1 を返し、free() は 1 以外でアボートするようにしておく。
//
void* malloc(size_t size)
{
    return reinterpret_cast<void*>(1);
}

void free(void* p)
{
    NN_ABORT_UNLESS( p == reinterpret_cast<void*>(1) );
}

void* calloc(size_t num, size_t size)
{
    return reinterpret_cast<void*>(1);
}

void* realloc(void* p, size_t newSize)
{
    if (newSize == 0)
    {
        NN_ABORT_UNLESS( p == reinterpret_cast<void*>(1) );
    }

    return reinterpret_cast<void*>(1);
}

//-----------------------------------------------------------------------------

}   // extern "C"

