﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/applet/applet.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nnt { namespace vi { // NOLINT(whitespace/braces)

class Service;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(Service, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(Service)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectLayer, (::std::int32_t slot))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectLayer, (::std::int32_t slot))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectLayerProducerEndPoint, (::nn::sf::Out<::nn::vi::IndirectProducerHandleType> outHandle, ::std::int32_t slot, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectLayerProducerEndPoint, (::std::int32_t slot))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectLayerConsumerEndPoint, (::nn::sf::Out<::nn::vi::IndirectConsumerHandleType> outHandle, ::std::int32_t slot, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectLayerConsumerEndPoint, (::std::int32_t slot))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetIndirectLayerProducerFlipOffset, (::std::int32_t slot, ::nn::TimeSpan offset))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(Service)

        ::nn::Result CreateIndirectLayer(::std::int32_t slot) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateIndirectLayer, (slot));
        }

        ::nn::Result DestroyIndirectLayer(::std::int32_t slot) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyIndirectLayer, (slot));
        }

        ::nn::Result CreateIndirectLayerProducerEndPoint(::nn::sf::Out<::nn::vi::IndirectProducerHandleType> outHandle, ::std::int32_t slot, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateIndirectLayerProducerEndPoint, (outHandle, slot, aruid));
        }

        ::nn::Result DestroyIndirectLayerProducerEndPoint(::std::int32_t slot) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyIndirectLayerProducerEndPoint, (slot));
        }

        ::nn::Result CreateIndirectLayerConsumerEndPoint(::nn::sf::Out<::nn::vi::IndirectConsumerHandleType> outHandle, ::std::int32_t slot, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateIndirectLayerConsumerEndPoint, (outHandle, slot, aruid));
        }

        ::nn::Result DestroyIndirectLayerConsumerEndPoint(::std::int32_t slot) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyIndirectLayerConsumerEndPoint, (slot));
        }

        ::nn::Result SetIndirectLayerProducerFlipOffset(::std::int32_t slot, ::nn::TimeSpan offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetIndirectLayerProducerFlipOffset, (slot, offset));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class Service
    {
    public:
        nn::Result CreateIndirectLayer(std::int32_t slot) NN_NOEXCEPT;
        nn::Result DestroyIndirectLayer(std::int32_t slot) NN_NOEXCEPT;
        nn::Result CreateIndirectLayerProducerEndPoint(nn::sf::Out<nn::vi::IndirectProducerHandleType> outHandle, std::int32_t slot, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result DestroyIndirectLayerProducerEndPoint(std::int32_t slot) NN_NOEXCEPT;
        nn::Result CreateIndirectLayerConsumerEndPoint(nn::sf::Out<nn::vi::IndirectConsumerHandleType> outHandle, std::int32_t slot, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result DestroyIndirectLayerConsumerEndPoint(std::int32_t slot) NN_NOEXCEPT;
        nn::Result SetIndirectLayerProducerFlipOffset(std::int32_t slot, nn::TimeSpan offset) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateIndirectLayer(std::int32_t slot) NN_NOEXCEPT;
    nn::Result DestroyIndirectLayer(std::int32_t slot) NN_NOEXCEPT;
    nn::Result CreateIndirectLayerProducerEndPoint(nn::sf::Out<nn::vi::IndirectProducerHandleType> outHandle, std::int32_t slot, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result DestroyIndirectLayerProducerEndPoint(std::int32_t slot) NN_NOEXCEPT;
    nn::Result CreateIndirectLayerConsumerEndPoint(nn::sf::Out<nn::vi::IndirectConsumerHandleType> outHandle, std::int32_t slot, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result DestroyIndirectLayerConsumerEndPoint(std::int32_t slot) NN_NOEXCEPT;
    nn::Result SetIndirectLayerProducerFlipOffset(std::int32_t slot, nn::TimeSpan offset) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nnt::vi::Service))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectLayer, (::std::int32_t slot))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateIndirectLayer, (slot));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectLayer, (::std::int32_t slot))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyIndirectLayer, (slot));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectLayerProducerEndPoint, (::nn::sf::Out<::nn::vi::IndirectProducerHandleType> outHandle, ::std::int32_t slot, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateIndirectLayerProducerEndPoint, (outHandle, slot, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectLayerProducerEndPoint, (::std::int32_t slot))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyIndirectLayerProducerEndPoint, (slot));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectLayerConsumerEndPoint, (::nn::sf::Out<::nn::vi::IndirectConsumerHandleType> outHandle, ::std::int32_t slot, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateIndirectLayerConsumerEndPoint, (outHandle, slot, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectLayerConsumerEndPoint, (::std::int32_t slot))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyIndirectLayerConsumerEndPoint, (slot));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetIndirectLayerProducerFlipOffset, (::std::int32_t slot, ::nn::TimeSpan offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetIndirectLayerProducerFlipOffset, (slot, offset));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nnt::vi::Service>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nnt::vi::Service))

    // nn::Result CreateIndirectLayer(std::int32_t slot) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateIndirectLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(slot, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (slot))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slot)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateIndirectLayer)

    // nn::Result DestroyIndirectLayer(std::int32_t slot) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyIndirectLayer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(slot, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (slot))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slot)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyIndirectLayer)

    // nn::Result CreateIndirectLayerProducerEndPoint(nn::sf::Out<nn::vi::IndirectProducerHandleType> outHandle, std::int32_t slot, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateIndirectLayerProducerEndPoint)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1010)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(slot, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (slot, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHandle, (::nn::vi::IndirectProducerHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slot), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateIndirectLayerProducerEndPoint)

    // nn::Result DestroyIndirectLayerProducerEndPoint(std::int32_t slot) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyIndirectLayerProducerEndPoint)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1011)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(slot, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (slot))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slot)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyIndirectLayerProducerEndPoint)

    // nn::Result CreateIndirectLayerConsumerEndPoint(nn::sf::Out<nn::vi::IndirectConsumerHandleType> outHandle, std::int32_t slot, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateIndirectLayerConsumerEndPoint)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1020)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(slot, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (slot, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHandle, (::nn::vi::IndirectConsumerHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slot), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateIndirectLayerConsumerEndPoint)

    // nn::Result DestroyIndirectLayerConsumerEndPoint(std::int32_t slot) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyIndirectLayerConsumerEndPoint)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1021)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(slot, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (slot))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slot)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyIndirectLayerConsumerEndPoint)

    // nn::Result SetIndirectLayerProducerFlipOffset(std::int32_t slot, nn::TimeSpan offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetIndirectLayerProducerFlipOffset)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1030)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(slot, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::nn::TimeSpan), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (slot, offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slot), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetIndirectLayerProducerFlipOffset)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::IndirectProducerHandleType), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::IndirectConsumerHandleType), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::TimeSpan), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nnt::vi::Service, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nnt::vi::Service))

    // nn::Result CreateIndirectLayer(std::int32_t slot) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectLayer, (::std::int32_t slot))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateIndirectLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slot)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateIndirectLayer)
    }

    // nn::Result DestroyIndirectLayer(std::int32_t slot) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectLayer, (::std::int32_t slot))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyIndirectLayer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slot)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyIndirectLayer)
    }

    // nn::Result CreateIndirectLayerProducerEndPoint(nn::sf::Out<nn::vi::IndirectProducerHandleType> outHandle, std::int32_t slot, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectLayerProducerEndPoint, (::nn::sf::Out<::nn::vi::IndirectProducerHandleType> outHandle, ::std::int32_t slot, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateIndirectLayerProducerEndPoint)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slot)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateIndirectLayerProducerEndPoint)
    }

    // nn::Result DestroyIndirectLayerProducerEndPoint(std::int32_t slot) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectLayerProducerEndPoint, (::std::int32_t slot))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyIndirectLayerProducerEndPoint)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slot)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyIndirectLayerProducerEndPoint)
    }

    // nn::Result CreateIndirectLayerConsumerEndPoint(nn::sf::Out<nn::vi::IndirectConsumerHandleType> outHandle, std::int32_t slot, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateIndirectLayerConsumerEndPoint, (::nn::sf::Out<::nn::vi::IndirectConsumerHandleType> outHandle, ::std::int32_t slot, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateIndirectLayerConsumerEndPoint)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slot)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateIndirectLayerConsumerEndPoint)
    }

    // nn::Result DestroyIndirectLayerConsumerEndPoint(std::int32_t slot) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyIndirectLayerConsumerEndPoint, (::std::int32_t slot))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyIndirectLayerConsumerEndPoint)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slot)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyIndirectLayerConsumerEndPoint)
    }

    // nn::Result SetIndirectLayerProducerFlipOffset(std::int32_t slot, nn::TimeSpan offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetIndirectLayerProducerFlipOffset, (::std::int32_t slot, ::nn::TimeSpan offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetIndirectLayerProducerFlipOffset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slot)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetIndirectLayerProducerFlipOffset)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nnt::vi::Service>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nnt::vi::Service))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateIndirectLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(slot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyIndirectLayer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(slot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateIndirectLayerProducerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateIndirectLayerProducerEndPoint)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(slot),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyIndirectLayerProducerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyIndirectLayerProducerEndPoint)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(slot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateIndirectLayerConsumerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateIndirectLayerConsumerEndPoint)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(slot),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyIndirectLayerConsumerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyIndirectLayerConsumerEndPoint)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(slot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetIndirectLayerProducerFlipOffset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetIndirectLayerProducerFlipOffset)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(slot),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyIndirectLayer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateIndirectLayerProducerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyIndirectLayerProducerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateIndirectLayerConsumerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyIndirectLayerConsumerEndPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetIndirectLayerProducerFlipOffset)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nnt::vi::Service))
