﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>
#include <cstdlib>

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nnt.h>
#include <nn/usb/usb_Host.h>

#define NNT_USB_CYWB_BL_4_BYTES_COPY(destination,source) {memcpy((void *)(destination), (void *)(source), 4);}


namespace nnt {
namespace usb {

    const int UPortMaxBufSize = 2048;

    enum Fx3FwErrorCode
    {
        Fx3FwErrorCode_Success = 0,
        Fx3FwErrorCode_Failed,
        Fx3FwErrorCode_InvalidMediaType,
        Fx3FwErrorCode_InvalidFwSignature,
        Fx3FwErrorCode_DeviceCreatedFailed,
        Fx3FwErrorCode_IncorrectImageLength,
        Fx3FwErrorCode_InvalidFile,
        Fx3FwErrorCode_SpiLashEraseFailed,
        Fx3FwErrorCode_CorruptFwImageFile,
        Fx3FwErrorCode_I2CE2PromUnknownSize,
    };

    const int Fx3BootLoaderVID             = 0x04B4;
    const int Fx3BootLoaderPID             = 0x00F3;
    const uint8_t Fx3ControlInterfaceClass = 0xFF;

    class TestFx3Utility
    {
    public:
        TestFx3Utility();
        ~TestFx3Utility();

        nn::Result Initialize(int seconds);
        bool IsInitialized();
        void Finalize();
        Fx3FwErrorCode UpdateFirmware(const char* fx3Firmware, int size);

    private:
        nn::Result DownloadBufferToDevice(unsigned int start_addr, long size, unsigned char *data_buf, uint8_t opCode);
        nn::Result UploadBufferFromDevice(unsigned int start_addr, long size, unsigned char *data_buf, uint8_t opCode);

        int32_t                             m_IfCount;
        nn::usb::InterfaceQueryOutput       m_IfList[nn::usb::HsLimitMaxInterfacesCount];
        bool                                m_IsInitialized;
        nn::usb::Host                       m_HsClient;
        nn::usb::HostInterface              m_Fx3Interface;
        nn::os::SystemEventType             m_IfAvailableEvent;
        nn::os::SystemEventType*            m_pIfStateChangedEvent;
        nn::usb::DeviceFilter               m_Fx3DeviceFilter;
    };

} // usb
} // nnt
