﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{GraphicsObject.h,PageSampleNvnTutorialLibrary}
 *
 * @brief
 *  This files defines a simple base class that handles
 *  render state setting for a given loaded model.
 */

#pragma once

#include <nvn\nvn.h>
#include <string>
#include <vector>

class UniformBufferManager;
class ManagedUniformBuffer;
class AssetFileDataHolder;

class GraphicsObject
{
    public:
        GraphicsObject() ;
        virtual ~GraphicsObject() ;

        virtual void SetupUniforms(UniformBufferManager* pUniformBufferManager) = 0;
        virtual void UpdateUniforms() = 0;

        virtual const std::string& GetName() const ;
        virtual void BindState(NVNcommandBuffer* pCommandBuffer) const ;

        virtual void Draw(NVNcommandBuffer* pCommandBuffer) const = 0;

    protected:
        void SetDefaultState() ;

        std::string m_Name;

        NVNblendState        m_BlendState;
        NVNchannelMaskState  m_ChannelMaskState;
        NVNcolorState        m_ColorState;
        NVNdepthStencilState m_DepthStencilState;
        NVNmultisampleState  m_MultisampleState;
        NVNpolygonState      m_PolygonState;

        AssetFileDataHolder* m_pAssetData;
};
