﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testNpt_Config.h"

namespace nnt { namespace npt { namespace wrapper {
    //==================================================
    // API実行時のログ設定
    //==================================================
    enum LogMode
    {
        LogMode_None = 0,
        LogMode_Aging = 1 << 0,
    };

    void SetApiCallLoggingMode(const uint32_t mode) NN_NOEXCEPT;

    //==================================================
    // NPTライブラリ実行用のラッパー関数
    //==================================================
    nn::Result Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    nn::Result ListDevices(nn::nfc::DeviceHandle* pOutBuffer, int* pOutCount, int bufferCount) NN_NOEXCEPT;
    nn::Result StartDetection(const nn::nfc::DeviceHandle& deviceHandle, nn::nfc::NfcProtocol protocolFilter) NN_NOEXCEPT;
    nn::Result StartDetection(const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result StartDetection(nn::nfc::NfcProtocol protocolFilter) NN_NOEXCEPT;
    nn::Result StartDetection() NN_NOEXCEPT;
    nn::Result StopDetection(const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result StopDetection() NN_NOEXCEPT;
    nn::Result GetTagInfo(nn::nfc::TagInfo* pOutTagInfo, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result GetTagInfo(nn::nfc::TagInfo* pOutTagInfo) NN_NOEXCEPT;
    nn::Result AttachActivateEvent(nn::os::SystemEventType* pEvent, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result AttachActivateEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT;
    nn::Result AttachDeactivateEvent(nn::os::SystemEventType* pEvent, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result AttachDeactivateEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT;
    nn::Result AttachAvailabilityChangeEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT;
    nn::nfc::State GetState() NN_NOEXCEPT;
    nn::nfc::DeviceState GetDeviceState(const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::nfc::DeviceState GetDeviceState() NN_NOEXCEPT;
    nn::Result SendCommandByPassThrough(void* pOutBuffer, size_t* pOutSize, const nn::nfc::DeviceHandle& deviceHandle, const void* pData, size_t dataSize, size_t bufferSize, nn::TimeSpan timeout) NN_NOEXCEPT;
    nn::Result SendCommandByPassThrough(void* pOutBuffer, size_t* pOutSize, const void* pData, size_t dataSize, size_t bufferSize, nn::TimeSpan timeout) NN_NOEXCEPT;
    nn::Result GetNpadId(nn::hid::NpadIdType* pOutNpadId, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result GetNpadId(nn::hid::NpadIdType* pOutNpadId) NN_NOEXCEPT;
    nn::Result KeepPassThroughSession(const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result KeepPassThroughSession() NN_NOEXCEPT;
    nn::Result ReleasePassThroughSession(const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result ReleasePassThroughSession() NN_NOEXCEPT;
    nn::Result InitializeSystem() NN_NOEXCEPT;
    void FinalizeSystem() NN_NOEXCEPT;
    nn::Result InitializeDebug() NN_NOEXCEPT;
    void FinalizeDebug() NN_NOEXCEPT;
}}} // end of namespace nnt::npt::wrapper
