﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testMifare_Config.h"

namespace nnt { namespace mifare {
    //------------------------------------------------------------------
    // ユーティリティ関数用定数です
    //------------------------------------------------------------------

    //======================================================
    // テストで使用するデータです。
    //======================================================

    //==================================================
    // プラットフォーム毎に異なる処理をラップします。
    //==================================================

    nn::Result InitializeSystem() NN_NOEXCEPT;
    nn::Result FinalizeSystem() NN_NOEXCEPT;
    nn::Result SetDefaultActivateEvent() NN_NOEXCEPT;
    nn::Result SetDefaultDeactivateEvent() NN_NOEXCEPT;
    void DestroyDefaultActivateEvent() NN_NOEXCEPT;
    void DestroyDefaultDeactivateEvent() NN_NOEXCEPT;
    bool WaitForActivate(int ms) NN_NOEXCEPT;
    bool WaitForActivate() NN_NOEXCEPT;
    bool WaitForDeactivate(int ms) NN_NOEXCEPT;
    bool WaitForDeactivate() NN_NOEXCEPT;

    //==================================================
    // MIFARE ライブラリの API をラップしてリトライに対応した関数です。
    //==================================================

    nn::Result InitializeWithRetry() NN_NOEXCEPT;
    nn::Result InitializeSystemWithRetry() NN_NOEXCEPT;

    //==================================================
    // 頻繁に利用されるシーケンスをまとめた関数です。
    //==================================================

    NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceHandle GetCurrentDeviceHandle() NN_NOEXCEPT;
    void SetCurrentDeviceHandle(NNT_NFC_COMMON_IF_NAMESPACE_MIFARE::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result SearchDeviceHandle() NN_NOEXCEPT;
    void DoSearchDeviceHandle() NN_NOEXCEPT;
    void DoSearch() NN_NOEXCEPT;
    void DoActivate() NN_NOEXCEPT;

    //==================================================
    // その他のユーティリティです。
    //==================================================

    void Sleep(int ms) NN_NOEXCEPT;
    void CreateRandomNumberSequence(nn::Bit16* pOut, int size) NN_NOEXCEPT;
    void CreateRandomNumberSequence(char* pOut, int size) NN_NOEXCEPT;
    void NfcOn() NN_NOEXCEPT;
    void NfcOff() NN_NOEXCEPT;
    const char* GetMifareResultTypeString(nn::Result result) NN_NOEXCEPT;
    bool CheckNpadStyle(nn::hid::NpadIdType npadId) NN_NOEXCEPT;
    bool IsNfcEnable() NN_NOEXCEPT;
    void InitializeHidController() NN_NOEXCEPT;
    void CheckNPadId(nn::hid::NpadIdType npadId) NN_NOEXCEPT;
    void PrintWriteBlockParameter(NNT_NFC_COMMON_IF_TYPE_MIFARE(WriteBlockParameter) * writeBlockParameter, int blockCount) NN_NOEXCEPT;
    void PrepareWriteParam(NNT_NFC_COMMON_IF_TYPE_MIFARE(WriteBlockParameter) * writeBlockParameter, int blockCount) NN_NOEXCEPT;
    void PrintReadBlockData(NNT_NFC_COMMON_IF_TYPE_MIFARE(ReadBlockData) * readBlockData, int blockCount) NN_NOEXCEPT;
    void PrepareReadParam(NNT_NFC_COMMON_IF_TYPE_MIFARE(ReadBlockParameter) * readBlockParameter, int blockCount) NN_NOEXCEPT;
    void CheckReadData(NNT_NFC_COMMON_IF_TYPE_MIFARE(ReadBlockData) * readBlockData, NNT_NFC_COMMON_IF_TYPE_MIFARE(WriteBlockParameter) * writeBlockParameter, int blockCount) NN_NOEXCEPT;
    void CreateBlockAddress(uint8_t* pBlockAddr) NN_NOEXCEPT;

}} // end of namespace nnt::mifare
