﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// プラットフォームによる実装分岐用のマクロを自動定義します。
#if defined(NN_NINTENDO_SDK)
    #define NNT_MIFARE_PLATFORM_NX
#else
    #error "サポートされないプラットフォームです。"
#endif //defined(NN_NINTENDO_SDK)

#if !defined(NNT_NFP_BUILD_CONFIG_OLD_LIBRARY) && defined(NNT_MIFARE_PLATFORM_NX)
#define NNT_NFC_COMMON_IF_NAMESPACE_MIFARE nn::nfc
#define NNT_NFC_COMMON_IF_NAMESPACE_STRING_MIFARE "nn::nfc"
#define NNT_NFC_COMMON_IF_TYPE_MIFARE(t) nn::nfc::Mifare##t
#include <nn/nfc.h>
#include <nn/nfc/nfc_PrivateApi.h>
#include <nn/nfc/nfc_PrivateResult.h>
#include <nn/nfc/nfc_ErrorApi.h>
#else
#define NNT_NFC_COMMON_IF_NAMESPACE_MIFARE nn::nfc::mifare
#define NNT_NFC_COMMON_IF_NAMESPACE_STRING_MIFARE "nn::nfc::mifare"
#define NNT_NFC_COMMON_IF_TYPE_MIFARE(t) nn::nfc::mifare::t
#include <nn/nfc/mifare/nfc_Mifare.h>
#include <nn/nfc/mifare/nfc_MifareEventApi.h>
#include <nn/nfc/mifare/nfc_MifareLib.h>
#include <nn/nfc/mifare/nfc_MifareMiscApi.h>
#include <nn/nfc/mifare/nfc_MifareNpadApi.h>
#include <nn/nfc/mifare/nfc_MifarePrivateResult.h>
#include <nn/nfc/mifare/nfc_MifareResult.h>
#include <nn/nfc/mifare/nfc_MifareTagApi.h>
#include <nn/nfc/mifare/nfc_MifareTypes.h>
#endif

#define NNT_MIFARE_MULTI_2DEVICES  // ２つのデバイスで試験を行うときに有効にする

namespace nnt { namespace mifare {
    // 読み書きの失敗時にリトライする回数と待機時間 (ms) です。
    const int RetryCountMax           = 5;
    const int RetryInterval           = 100;

    // デフォルトのタイムアウト時間 (ms) です。
    const int ActivateTimeout         = 5000;
    const int DeactivateTimeout       = 5000;
    const int ConnectTimeout          = 5000;
    const int DisconnectTimeout       = 5000;

}} // end of namespace nnt::mifare
