﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Log.h>
#include <nnt/ldn/testLdn_Config.h>

#define NNT_DETAIL_LDN_LOG(...) NN_LOG("[LDN] " __VA_ARGS__)
#define NNT_DETAIL_LDN_LOG_WITHOUT_PREFIX(...) NN_LOG(__VA_ARGS__)

/**
 * @def           NNT_LDN_LOG_DEBUG
 * @brief         デバッグ用のログ出力マクロです。
 */
#if defined(NNT_LDN_BUILD_CONFIG_DEBUG_LOG_LEVEL_DEBUG)
    #define NNT_LDN_LOG_DEBUG(...) NNT_DETAIL_LDN_LOG("(DEBUG) " __VA_ARGS__)
    #define NNT_LDN_LOG_DEBUG_WITHOUT_PREFIX(...) NNT_DETAIL_LDN_LOG_WITHOUT_PREFIX(__VA_ARGS__)
#else
    #define NNT_LDN_LOG_DEBUG(...)
    #define NNT_LDN_LOG_DEBUG_WITHOUT_PREFIX(...)
#endif

/**
 * @def           NNT_LDN_LOG_INFO
 * @brief         デバッグ用のログ出力マクロです。
 */
#if defined(NNT_LDN_BUILD_CONFIG_DEBUG_LOG_LEVEL_DEBUG) ||\
    defined(NNT_LDN_BUILD_CONFIG_DEBUG_LOG_LEVEL_INFO)
    #define NNT_LDN_LOG_INFO(...) NNT_DETAIL_LDN_LOG("(INFO) " __VA_ARGS__)
    #define NNT_LDN_LOG_INFO_WITHOUT_PREFIX(...) NNT_DETAIL_LDN_LOG_WITHOUT_PREFIX(__VA_ARGS__)
#else
    #define NNT_LDN_LOG_INFO(...)
    #define NNT_LDN_LOG_INFO_WITHOUT_PREFIX(...)
#endif

/**
 * @def           NNT_LDN_LOG_WARN
 * @brief         デバッグ用のログ出力マクロです。
 */
#if defined(NNT_LDN_BUILD_CONFIG_DEBUG_LOG_LEVEL_DEBUG) ||\
    defined(NNT_LDN_BUILD_CONFIG_DEBUG_LOG_LEVEL_INFO) ||\
    defined(NNT_LDN_BUILD_CONFIG_DEBUG_LOG_LEVEL_WARNING)
    #define NNT_LDN_LOG_WARN(...) NNT_DETAIL_LDN_LOG("(WARNING) " __VA_ARGS__)
    #define NNT_LDN_LOG_WARN_WITHOUT_PREFIX(...) NNT_DETAIL_LDN_LOG_WITHOUT_PREFIX(__VA_ARGS__)
#else
    #define NNT_LDN_LOG_WARN(...)
    #define NNT_LDN_LOG_WARN_WITHOUT_PREFIX(...)
#endif


/**
 * @def           NNT_LDN_LOG_ERROR
 * @brief         デバッグ用のログ出力マクロです。
 */
#if defined(NNT_LDN_BUILD_CONFIG_DEBUG_LOG_LEVEL_DEBUG) ||\
    defined(NNT_LDN_BUILD_CONFIG_DEBUG_LOG_LEVEL_INFO) ||\
    defined(NNT_LDN_BUILD_CONFIG_DEBUG_LOG_LEVEL_WARNING) ||\
    defined(NNT_LDN_BUILD_CONFIG_DEBUG_LOG_LEVEL_ERROR)
    #define NNT_LDN_LOG_ERROR(...) NNT_DETAIL_LDN_LOG("(ERROR) " __VA_ARGS__)
    #define NNT_LDN_LOG_ERROR_WITHOUT_PREFIX(...) NNT_DETAIL_LDN_LOG_WITHOUT_PREFIX(__VA_ARGS__)
#else
    #define NNT_LDN_LOG_ERROR(...)
    #define NNT_LDN_LOG_ERROR_WITHOUT_PREFIX(...)
#endif
