﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_StringView.h>

namespace nnt { namespace ldn { namespace detail
{
    class XmlNode
    {
        NN_DISALLOW_COPY(XmlNode);

    public:

        nn::util::string_view GetName() const NN_NOEXCEPT;

        nn::util::string_view GetText() const NN_NOEXCEPT;

        const XmlNode* FindChild(const nn::util::string_view& name) const NN_NOEXCEPT;
    };

    class XmlParser
    {
        NN_DISALLOW_COPY(XmlParser);

    public:

        XmlParser() NN_NOEXCEPT;

        ~XmlParser() NN_NOEXCEPT;

        bool Parse(char* document) NN_NOEXCEPT;

        void Clear() NN_NOEXCEPT;

        const XmlNode* GetRoot() const NN_NOEXCEPT;

    private:

        class Impl;
        Impl* m_pImpl;
    };

}}} // namespace nnt::ldn::detail
