﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace ldn { namespace detail
{
    class XmlBuilder
    {
        NN_DISALLOW_COPY(XmlBuilder);

    public:

        XmlBuilder(void* buffer, size_t bufferSize) NN_NOEXCEPT;

        ~XmlBuilder() NN_NOEXCEPT;

        void Clear() NN_NOEXCEPT;

        void OpenTag(const char* tag) NN_NOEXCEPT;

        void CloseTag(const char* tag) NN_NOEXCEPT;

        void Add(const char* text) NN_NOEXCEPT;

        void Add(int data) NN_NOEXCEPT;

        void Add(const void* data, size_t dataSize) NN_NOEXCEPT;

        const char* GetData() const NN_NOEXCEPT;

        size_t GetDataSize() const NN_NOEXCEPT;

    private:

        void Terminate() NN_NOEXCEPT;

        char* m_Buffer;
        size_t m_MaxSize;
        size_t m_Pos;
    };

}}} // namespace nnt::ldn::detail
