﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>

#include <nn/fs.h>
#include <nn/nn_Common.h>

namespace nn { namespace fs {
    class FileHandleStorage;
}}

namespace nn { namespace fssystem {
    class IBufferManager;
    class IMacGenerator;
}}

namespace nn { namespace fssystem { namespace save {
    class JournalIntegritySaveDataFileSystemDriver;
}}}

namespace nnt { namespace fs { namespace util {

    const int SaveDataMinimumVersion = 4;

    void InitializeSaveDataTestHelper() NN_NOEXCEPT;

    void FinalizeSaveDataTestHelper() NN_NOEXCEPT;

    nn::fssystem::IMacGenerator* GetMacGenerator() NN_NOEXCEPT;

#if defined(NN_BUILD_CONFIG_OS_WIN)
    nn::fssystem::IMacGenerator* GetDeviceMacGenerator() NN_NOEXCEPT;
#endif // defined(NN_BUILD_CONFIG_OS_WIN)

    void GenerateRandomForSaveDataTest(void* pData, size_t size) NN_NOEXCEPT;

    class SaveDataFileSystemMounter
    {
    public:
        explicit SaveDataFileSystemMounter(nn::fssystem::IBufferManager* pBufferManager) NN_NOEXCEPT;

        ~SaveDataFileSystemMounter() NN_NOEXCEPT;

    public:
#if defined(NN_BUILD_CONFIG_OS_WIN)
        nn::fssystem::save::JournalIntegritySaveDataFileSystemDriver* GetFileSystem() NN_NOEXCEPT
        {
            return GetPrivateData()->pFileSystem.get();
        }

        void Mount(nn::fs::SaveDataSpaceId spaceId, nn::fs::SystemSaveDataId id) NN_NOEXCEPT;
#endif // defined(NN_BUILD_CONFIG_OS_WIN)

        static void ReadFile(size_t* outValue, nn::fs::SaveDataSpaceId spaceId, nn::fs::SaveDataId id, int64_t offset, char* buffer, size_t size) NN_NOEXCEPT;
        static void WriteFile(nn::fs::SaveDataSpaceId spaceId, nn::fs::SaveDataId id, int64_t offset, const char* buffer, size_t size) NN_NOEXCEPT;
        static void ClearSaveDataFileSystemCache() NN_NOEXCEPT;

    private:
        class SaveDataFileSystemMounterPrivateData
        {
        public:
            std::unique_ptr<nn::fssystem::save::JournalIntegritySaveDataFileSystemDriver> pFileSystem;
            nn::fs::FileHandle file;
            std::unique_ptr<nn::fs::FileHandleStorage> pFileHandleStorage;
        };

    private:
        SaveDataFileSystemMounterPrivateData* GetPrivateData() NN_NOEXCEPT
        {
            return reinterpret_cast<SaveDataFileSystemMounterPrivateData*>(m_pPrivateData.get());
        }

        static void MountBis(nn::fs::SaveDataSpaceId spaceId) NN_NOEXCEPT;

        static void UnmountBis(nn::fs::SaveDataSpaceId spaceId) NN_NOEXCEPT;

        static void GetPath(char* path, size_t size, nn::fs::SaveDataSpaceId spaceId, nn::fs::SaveDataId id) NN_NOEXCEPT;

    private:
        static int g_BisMountCountUser;
        static int g_BisMountCountSystem;
#if defined(NN_BUILD_CONFIG_OS_WIN)
        nn::fssystem::IBufferManager* m_pBufferManager;
#endif // defined(NN_BUILD_CONFIG_OS_WIN)
        nn::fs::SaveDataSpaceId m_SpaceId;
        decltype(nnt::fs::util::AllocateBuffer(0)) m_pPrivateData;
    };

}}}
