﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace fs { namespace detail {
    bool IsSessionForRealtimeOnlyEnabled() NN_NOEXCEPT;
    void DisableSessionForRealtimeOnlyAndChangeSessionCount(int sessionCount) NN_NOEXCEPT;
    void EnableSessionForRealtimeOnly() NN_NOEXCEPT;
}}}

namespace nnt { namespace fs { namespace util {

    inline void RevertSessionSettingToDefault() NN_NOEXCEPT
    {
        if( nn::fs::detail::IsSessionForRealtimeOnlyEnabled() )
        {
            nn::fs::detail::EnableSessionForRealtimeOnly();
        }
        else
        {
            static const int SessionCount = 2;
            nn::fs::detail::DisableSessionForRealtimeOnlyAndChangeSessionCount(SessionCount);
        }
    }

}}}
