﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/fs.h>
#include <nn/ro.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/fsUtil/testFs_util_function.h>

namespace nnt { namespace fs { namespace util {

class ScopedDynamicModuleLoader
{
public:
    ScopedDynamicModuleLoader() NN_NOEXCEPT;

    ~ScopedDynamicModuleLoader() NN_NOEXCEPT;

    nn::Result Load(const char* mountName, const char* nrrPath, const char* nroPath) NN_NOEXCEPT;

private:
    static void Deallocate(void* ptr) NN_NOEXCEPT;

    typedef std::unique_ptr<void, decltype(&Deallocate)> Buffer;

    static Buffer Allocate(size_t size) NN_NOEXCEPT;

    static Buffer LoadFile(const char* filePath) NN_NOEXCEPT;

private:
    nnt::fs::util::String m_MountName;
    decltype(nnt::fs::util::AllocateBuffer(1)) m_MountCacheBuffer;
    Buffer m_NrrFileBuffer;
    Buffer m_NroFileBuffer;
    Buffer m_BssBuffer;
    nn::ro::RegistrationInfo m_Info;
    nn::ro::Module m_Module;
    bool m_IsRoInitialized;
    bool m_IsModuleInfoRegistered;
    bool m_IsModuleLoaded;
};

}}}
