﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fssystem/fs_ISaveDataExtraDataAccessor.h>

#include <nnt/fsApi/testFs_ApiCommon.h>

namespace nnt { namespace fs { namespace api {
    void LoadAllSaveDataExtraDataTests() NN_NOEXCEPT;

    void LoadPostConditionSaveDataExtraDataTests() NN_NOEXCEPT;

    struct TestSaveDataExtraDataAttribute
    {
        bool isCommitSaveDataExtraDataWhenWrite;

        TestSaveDataExtraDataAttribute() NN_NOEXCEPT
        {
            // 全変数に初期値を入れる
            isCommitSaveDataExtraDataWhenWrite = false;
        }
        ~TestSaveDataExtraDataAttribute() NN_NOEXCEPT
        {
        }
    };

    class ITestSaveDataExtraDataAccessor
    {
    public:
        virtual ~ITestSaveDataExtraDataAccessor() NN_NOEXCEPT {}
        virtual Result WriteExtraData(const nn::fs::SaveDataExtraData& extraData) NN_NOEXCEPT = 0;
        virtual Result CommitExtraData(bool updateTimeStamp) NN_NOEXCEPT = 0;
        virtual Result ReadExtraData(nn::fs::SaveDataExtraData* outValue) NN_NOEXCEPT = 0;
    };

    class TestSaveDataExtraDataInfo
    {
    public:
        ITestSaveDataExtraDataAccessor* saveDataExtraDataAccessor;
        std::function<nn::Result (nn::fs::SaveDataExtraData*, size_t) NN_NOEXCEPT> staticSaveDataExtraDataReader;

        TestSaveDataExtraDataAttribute attribute;

    public:
        static void* operator new(size_t size) NN_NOEXCEPT
        {
            return nnt::fs::util::Allocate(size);
        }
        static void operator delete(void* p, size_t size) NN_NOEXCEPT
        {
            nnt::fs::util::Deallocate(p, size);
        }
    };

    void GetTestSaveDataExtraDataInfo(std::unique_ptr<TestSaveDataExtraDataInfo>* outValue, ITestFileSystem* pFileSystem) NN_NOEXCEPT;

    class GetSaveDataExtraDataTestFixture : public CleanupFileSystemTestFixture
    {
    public:
        virtual ~GetSaveDataExtraDataTestFixture() NN_NOEXCEPT NN_OVERRIDE {}

    protected:
        virtual void SetUp() NN_NOEXCEPT NN_OVERRIDE
        {
            nnt::fs::api::CleanupFileSystemTestFixture::SetUp();
            nnt::fs::util::CheckMemoryLeakFixture::StopMemoryLeakCheck();
            std::unique_ptr<TestSaveDataExtraDataInfo> info;
            GetTestSaveDataExtraDataInfo(&info, &GetFs());
            m_pInfo = std::move(info);
            nnt::fs::util::CheckMemoryLeakFixture::StartMemoryCheck();
        }

        ITestSaveDataExtraDataAccessor& GetExtraDataAccessor() NN_NOEXCEPT
        {
            return *m_pInfo->saveDataExtraDataAccessor;
        }

        std::function<nn::Result (nn::fs::SaveDataExtraData*, size_t) NN_NOEXCEPT> GetStaticExtraDataReader() NN_NOEXCEPT
        {
            return m_pInfo->staticSaveDataExtraDataReader;
        }

        const TestSaveDataExtraDataAttribute& GetSaveDataExtraDataAttribute() const NN_NOEXCEPT
        {
            return m_pInfo->attribute;
        }

    private:
        std::unique_ptr<TestSaveDataExtraDataInfo> m_pInfo;
    };
}}}
