﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>

#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>

#include <nn/i2c/i2c.h>
#include <nn/i2c/i2c_BusDev.h> // Include development header not in nn/i2c/i2c.h

#include "test_Tmp451.h"
#include "../Common/test_Util.h"

namespace {

const nn::i2c::I2cDevice      I2cDeviceName      = nn::i2c::I2cDevice::I2cDevice_Tmp451;
const nn::Bit16               SlaveAddr          = 0x4c;
const uint8_t                 RegVendorId        = 0xfe;
const uint8_t                 DefaultValVendorId = 0x55;

}

namespace nnt { namespace i2c { namespace tmp451 {

//---------------------------------------------------------------------------
//  テスト用関数
//---------------------------------------------------------------------------

bool TEST_VariousSpeedModes( int targetBusIdx, const nn::i2c::SpeedMode* targetSpeedModes, int targetSpeedModeNum )
{
    nn::i2c::Initialize();
    nn::i2c::I2cSession i2c;

    for( int i = 0; i < targetSpeedModeNum; i++ )
    {
        NN_LOG("Test @ SpeedMode = %d [bps]\n", targetSpeedModes[i]);
        nn::i2c::OpenSessionForDev(&i2c, targetBusIdx, SlaveAddr, nn::i2c::AddressingMode_BitWidth7, targetSpeedModes[i]);

        nnt::i2c::util::TestReadRegister(i2c,
            reinterpret_cast<const char*>(&RegVendorId),        sizeof(RegVendorId),
            reinterpret_cast<const char*>(&DefaultValVendorId), sizeof(DefaultValVendorId)
            );
        if (::testing::Test::HasFatalFailure())
        {
            nn::i2c::CloseSession(i2c);
            nn::i2c::Finalize();
            return false;
        }
        nn::i2c::CloseSession(i2c);
    }

    nn::i2c::Finalize();

    return true;
}

bool TEST_I2cDeviceAccess()
{
    nn::i2c::Initialize();
    nn::i2c::I2cSession i2c;

    nn::i2c::OpenSession(&i2c, I2cDeviceName);

    nnt::i2c::util::TestReadRegister(i2c,
        reinterpret_cast<const char*>(&RegVendorId),        sizeof(RegVendorId),
        reinterpret_cast<const char*>(&DefaultValVendorId), sizeof(DefaultValVendorId)
    );

    if (::testing::Test::HasFatalFailure())
    {
        nn::i2c::CloseSession(i2c);
        nn::i2c::Finalize();
        return false;
    }

    nn::i2c::CloseSession(i2c);
    nn::i2c::Finalize();

    return true;
}

}}}  // namespace nnt::i2c::tmp451
