﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>

#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>

#include <nn/i2c/i2c.h>
#include <nn/i2c/i2c_BusDev.h> // Include development header not in nn/i2c/i2c.h

#include <nn/result/result_HandlingUtility.h>

#include "test_Bq24193.h"
#include "../Common/test_Util.h"

namespace {

    const nn::i2c::I2cDevice g_I2cDeviceName = nn::i2c::I2cDevice::I2cDevice_Bq24193;

    const nn::i2c::TransactionOption g_I2cTransStart     = nn::i2c::TransactionOption_StartCondition;
    const nn::i2c::TransactionOption g_I2cTransStartStop = static_cast<nn::i2c::TransactionOption>(
                                                               nn::i2c::TransactionOption_StartCondition
                                                             | nn::i2c::TransactionOption_StopCondition);

    nn::Result ReadRegister(uint8_t* pOutReceiveBuffer,
                            const nn::i2c::I2cSession& session,
                            uint8_t cmd,
                            int size) NN_NOEXCEPT
    {
        uint8_t commandList[nn::i2c::CommandListLengthCountMax];

        nn::i2c::CommandListFormatter commandListFormatter(commandList, sizeof(commandList));

        commandListFormatter.EnqueueSendCommand(g_I2cTransStart, &cmd, sizeof(cmd) );
        commandListFormatter.EnqueueReceiveCommand(g_I2cTransStartStop, size);

        NN_RESULT_DO(nn::i2c::ExecuteCommandList(pOutReceiveBuffer, size,
                                                 session, commandList, commandListFormatter.GetCurrentLength()));
        NN_RESULT_SUCCESS;
    }
}

namespace nnt { namespace i2c { namespace bq24193 {

//---------------------------------------------------------------------------
//  テスト用関数
//---------------------------------------------------------------------------

bool TEST_I2cDeviceAccess()
{
    const uint8_t regFieldLength = 0x0b;

    nn::i2c::Initialize();

    nn::i2c::I2cSession i2c;
    uint8_t reg = 0;

    NN_LOG("[bq24193] Start\n");

    nn::i2c::OpenSession(&i2c, g_I2cDeviceName);

    for ( uint8_t i = 0; i < regFieldLength; i++ )
    {
        ReadRegister(&reg, i2c, i, 1);

        NN_LOG("%02x : %02x\n", i, reg);
    }

    if ( ::testing::Test::HasFatalFailure() )
    {
        nn::i2c::CloseSession(i2c);
        nn::i2c::Finalize();
        return false;
    }

    nn::i2c::CloseSession(i2c);

    nn::i2c::Finalize();

    NN_LOG("[bq24193] End\n");

    return true;
}

}}}  // namespace nnt::i2c::bq24193
