﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  Alc5639 関連テストモジュール
//---------------------------------------------------------------------------

#pragma once

#include <nn/nn_Common.h>

#include <nn/i2c/i2c_BusDev.h> // Include development header not in nn/i2c/i2c.h

namespace nnt { namespace i2c { namespace alc5639 {

//---------------------------------------------------------------------------
//  テスト用関数
//---------------------------------------------------------------------------

/**
 * @brief       種々の動作速度で基本的な受信処理が正常に機能することをテストします
 *
 * @param[in]   targetBusIdx          対向デバイスがぶら下がるバス番号
 * @param[in]   targetSpeedModes      テストする種々の動作速度
 * @param[in]   targetSpeedModeNum    動作速度の数
 * @return      テストが成功したかどうかを返します
 * @retval      true        テストに成功
 * @retval      false       テストに失敗
 * @details     Alc5639 に対して指定された動作速度でデフォルト状態のベンダ ID を読み出して、
 *              それが所望の値であるかをテストします。
 *              テスト内部で生成したセッションはクローズされ、ライブラリは未初期化状態に戻ります。
 *              指定された動作速度で、順番に上記のテストを行います。
 */
bool TEST_VariousSpeedModes( int targetBusIdx, const nn::i2c::SpeedMode* targetSpeedModes, int targetSpeedModeNum );

/**
 * @brief       製品環境相当の I2cDevice 識別子を用いたアクセスができるかをテストします
 *
 * @return      テストが成功したかどうかを返します
 * @retval      true        テストに成功
 * @retval      false       テストに失敗
 * @details     デバイス識別子を使ったアクセスを行います。
 *              デフォルト状態のベンダ ID を読み出して、所望の値であるかをテストします。
 *              テスト内部で生成したセッションはクローズされ、ライブラリは未初期化状態に戻ります。
 */
bool TEST_I2cDeviceAccess();

}}}  // namespace nnt::i2c::alc5639
