﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  ユーティリティ関数
//---------------------------------------------------------------------------

#pragma once

#include <nn/nn_Common.h>

#include <nn/i2c/i2c.h>

namespace nnt { namespace i2c { namespace util {

void ClearBuffer(char* data, int dataBytes);
bool CompareTestData(const char* expectedData, const char* actualData, int dataBytes);
void TestReadRegister(nn::i2c::I2cSession& i2c, const char* pReg, size_t regBytes, const char* pExpectedData, size_t dataBytes );

}}}  // namespace nnt::i2c::util
