﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  クラシックコントローラを対向デバイスとしたテスト
//---------------------------------------------------------------------------

#include <nn/nn_Common.h>

#include <nnt/nntest.h>

#include "../TargetDevices/test_Clsic.h"

/**
 * I2C ドライバライブラリの基礎的な送受信機能を確認するテスト。
 */
TEST( TransactionTest, test_Basic )
{
    const int ReadTestTimes = 100;
    EXPECT_TRUE( nnt::i2c::clsic::TEST_BasicTransaction( ReadTestTimes ) );
}

/**
 * I2C ドライバライブラリのAuto Increment アクセスを試すテスト。
 */
TEST( TransactionTest, test_AutoIncrement )
{
    const int AutoIncrementTestTimes = 5;
    EXPECT_TRUE( nnt::i2c::clsic::TEST_AutoIncrementAccess( AutoIncrementTestTimes ) );
}

/**
 * I2C ドライバライブラリのコマンドリスト実行を試すテスト。
 */
TEST( TransactionTest, test_CommandList )
{
    EXPECT_TRUE( nnt::i2c::clsic::TEST_CommandList() );
}
