﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>

#include <nn/i2c/i2c.h>

#include "../TargetDevices/tool_Max77620Pmic.h"
#include "../TargetDevices/tool_Max77620Rtc.h"
#include "../TargetDevices/tool_Max77621Cpu.h"
#include "../TargetDevices/tool_Max77621Gpu.h"
#include "../TargetDevices/tool_Bq24193.h"
#include "../TargetDevices/tool_Max17050.h"
#include "../TargetDevices/tool_Fan53528.h"
#include "../TargetDevices/tool_Max77812_2_1_1.h"
#include "../TargetDevices/tool_Max77812_3_1.h"
#include "../TargetDevices/tool_Tmp451.h"

namespace {

inline void WarnUnlessResultSuccessImpl(const char* pStringizedExpression, const nn::Result& result) NN_NOEXCEPT
{
    if ( result.IsFailure() )
    {
        NN_LOG("Failed: %s\n  Module: %d\n  Description: %d\n  InnerValue: 0x%08x\n",
            pStringizedExpression, result.GetModule(), result.GetDescription(), result.GetInnerValueForDebug());
    }
}

} // namespace

#define NN_LOG_UNLESS_RESULT_SUCCESS(expression) \
    WarnUnlessResultSuccessImpl(NN_MACRO_STRINGIZE(expression), (expression))

extern "C" void nninitStartup()
{
    ;
}

extern "C" void nnMain()
{
    // HW 開発者向けコメント：
    // ダンプするデバイスを限定する場合はここを編集してください
    NN_LOG_UNLESS_RESULT_SUCCESS(nnt::i2c::max77620pmic::DumpRegisters());
    NN_LOG_UNLESS_RESULT_SUCCESS(nnt::i2c::max77620rtc::DumpRegisters());
    NN_LOG_UNLESS_RESULT_SUCCESS(nnt::i2c::max77621cpu::DumpRegisters());
    NN_LOG_UNLESS_RESULT_SUCCESS(nnt::i2c::max77621gpu::DumpRegisters());
    NN_LOG_UNLESS_RESULT_SUCCESS(nnt::i2c::bq24193::DumpRegisters());
    NN_LOG_UNLESS_RESULT_SUCCESS(nnt::i2c::max17050::DumpRegisters());
    NN_LOG_UNLESS_RESULT_SUCCESS(nnt::i2c::fan53528::DumpRegisters());
    NN_LOG_UNLESS_RESULT_SUCCESS(nnt::i2c::max77812_2_1_1::DumpRegisters());
    NN_LOG_UNLESS_RESULT_SUCCESS(nnt::i2c::max77812_3_1::DumpRegisters());
    NN_LOG_UNLESS_RESULT_SUCCESS(nnt::i2c::tmp451::DumpRegisters());
}
