﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/http/json/http_JsonPath.h>

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

namespace nnt { namespace http {

template <typename BaseAdaptor>
class JsonPrintAdaptor
{
public:
    typedef typename BaseAdaptor::JsonPathType JsonPathType;
private:
    BaseAdaptor& m_Base;
public:
    explicit JsonPrintAdaptor(BaseAdaptor& base) NN_NOEXCEPT
        : m_Base(base)
    {
    }
    void Update(const JsonPathType& jsonPath, std::nullptr_t) NN_NOEXCEPT
    {
        NN_LOG("%s: null\n", jsonPath.ToString());
        m_Base.Update(jsonPath, nullptr);
    }
    void Update(const JsonPathType& jsonPath, bool value) NN_NOEXCEPT
    {
        NN_LOG("%s: %s\n", jsonPath.ToString(), value? "true": "false");
        m_Base.Update(jsonPath, value);
    }
    void Update(const JsonPathType& jsonPath, int64_t value) NN_NOEXCEPT
    {
        NN_LOG("%s: %lld\n", jsonPath.ToString(), value);
        m_Base.Update(jsonPath, value);
    }
    void Update(const JsonPathType& jsonPath, uint64_t value) NN_NOEXCEPT
    {
        NN_LOG("%s: %llu\n", jsonPath.ToString(), value);
        m_Base.Update(jsonPath, value);
    }
    void Update(const JsonPathType& jsonPath, double value) NN_NOEXCEPT
    {
        NN_LOG("%s: %lf\n", jsonPath.ToString(), value);
        m_Base.Update(jsonPath, value);
    }
    void Update(const JsonPathType& jsonPath, const char* value, int valueLength) NN_NOEXCEPT
    {
        NN_LOG("%s: \"%s\"\n", jsonPath.ToString(), value);
        m_Base.Update(jsonPath, value, valueLength);
    }
    void NotifyObjectBegin(const JsonPathType& jsonPath) NN_NOEXCEPT
    {
        NN_LOG("%s: [ObjectBegin]\n", jsonPath.ToString());
        m_Base.NotifyObjectBegin(jsonPath);
    }
    void NotifyObjectEnd(const JsonPathType& jsonPath) NN_NOEXCEPT
    {
        NN_LOG("%s: [ObjectEnd]\n", jsonPath.ToString());
        m_Base.NotifyObjectEnd(jsonPath);
    }
};

}} // ~namespace nnt::http
