﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/htcsUtil/testHtcs_utilData.h>

namespace nnt { namespace htcs { namespace util {
    void FillBuffer(uint8_t* buffer, size_t size)
    {
        for (size_t i = 0; i < size; i++)
        {
            // データが周期的になるのを防ぐため、適当に演算
            buffer[i] = static_cast<uint8_t>((i & 0xff) ^ ((i & 0xff00) >> 8) ^ ((i & 0xff0000) >> 16) ^ ((i & 0xff000000) >> 24));
        }
    }
}}}
