﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>

#include <nn/nn_Result.h>
#include <nn/nn_StaticAssert.h>

#include <nn/htclow.h>
#include <nn/htclow/detail/htclow_InternalTypes.h>

#include "../../../../../Programs/Eris/Sources/Libraries/htclow/server/htclow_Packet.h"

namespace nnt { namespace htclow {

void AssertSynPacket(const nn::htclow::server::ReceivePacket& packet, nn::htclow::detail::ChannelInternalType channel) NN_NOEXCEPT;
void AssertDataPacket(const nn::htclow::server::ReceivePacket& packet, nn::htclow::detail::ChannelInternalType channel, int64_t sequenceId, const void* body, int bodySize) NN_NOEXCEPT;
void AssertDataAckPacket(const nn::htclow::server::ReceivePacket& packet, nn::htclow::detail::ChannelInternalType channel, int64_t sequenceId) NN_NOEXCEPT;
void AssertFinPacket(const nn::htclow::server::ReceivePacket& packet, nn::htclow::detail::ChannelInternalType channel, int64_t sequenceId) NN_NOEXCEPT;
void AssertFinAckPacket(const nn::htclow::server::ReceivePacket& packet, nn::htclow::detail::ChannelInternalType channel, int64_t sequenceId) NN_NOEXCEPT;

std::unique_ptr<nn::htclow::server::SendPacket> MakeDataPacket(nn::htclow::detail::ChannelInternalType channel, int64_t sequenceId, const void* body, int bodySize) NN_NOEXCEPT;
std::unique_ptr<nn::htclow::server::SendPacket> MakeDataAckPacket(nn::htclow::detail::ChannelInternalType channel, int64_t sequenceId) NN_NOEXCEPT;
std::unique_ptr<nn::htclow::server::SendPacket> MakeSynAckPacket(nn::htclow::detail::ChannelInternalType channel) NN_NOEXCEPT;
std::unique_ptr<nn::htclow::server::SendPacket> MakeFinPacket(nn::htclow::detail::ChannelInternalType channel, int64_t sequenceId) NN_NOEXCEPT;
std::unique_ptr<nn::htclow::server::SendPacket> MakeFinAckPacket(nn::htclow::detail::ChannelInternalType channel, int64_t sequenceId) NN_NOEXCEPT;

std::unique_ptr<nn::htclow::server::ReceivePacket> ReceivePacketForTest() NN_NOEXCEPT;
void SendPacketForTest(const nn::htclow::server::SendPacket& packet) NN_NOEXCEPT;

}}
