﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "hidfw/gfx.h"
#include "hidfw/hid.h"
#include "hidfw/layout.h"

#include <nn/irsensor.h>
#include <nn/nfc.h>
#include <nn/hid/hid_NpadSixAxisSensor.h>
#include <nn/hid/hid_SixAxisSensor.h>
#include <nn/hid/system/hid_SixAxisSensorCalibration.h>

#include <nn/nn_Log.h>

namespace nnt {
    void InitializeExclusiveFunc(size_t index);
    void MakeExclusiveFuncButtons(float x, float y);
    void UpdateExclusiveFuncButtons(size_t index);
    void DrawExclusiveFuncButtons(size_t index);
    void Active(size_t index);
    void Deactive(size_t index);
    void ReInit(size_t index);
}
