﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/util/util_Vector.h>

#include "IMotionDetector.h"

class PushMotionDetector final : public IMotionDetector
{
    NN_DISALLOW_COPY(PushMotionDetector);
    NN_DISALLOW_MOVE(PushMotionDetector);

public:

    PushMotionDetector() NN_NOEXCEPT;

    virtual ~PushMotionDetector() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Reset() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Update(const SixAxisSensorRawState& rawState) NN_NOEXCEPT NN_OVERRIDE;

    virtual int GetMotions(MotionState* pOutStates, int count) NN_NOEXCEPT NN_OVERRIDE;

private:

    bool m_IsPushStarted; // push モーションが開始中か
    float m_ThresholdPushDetectAccLengthSquared; // push モーションの検出閾値です
};
