﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_NpadCommon.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/hid/hid_NpadJoyDual.h>

#include "JoyDualSixAxisSensor.h"
#include "SixAxisSensorGestureProcessor/SixAxisSensorGestureProcessor.h"

namespace
{
    void PrintGesture(const GestureState& gestureState)
    {
        switch (gestureState.gestureType)
        {
        case GestureType::GestureType_Peak:         NN_LOG("Peak         : "); break;
        case GestureType::GestureType_Shake:        NN_LOG("Shake        : "); break;
        case GestureType::GestureType_RotatePlusX:  NN_LOG("RotatePlusX  : "); break;
        case GestureType::GestureType_RotatePlusY:  NN_LOG("RotatePlusY  : "); break;
        case GestureType::GestureType_RotatePlusZ:  NN_LOG("RotatePlusZ  : "); break;
        case GestureType::GestureType_RotateMinusX: NN_LOG("RotateMinusX : "); break;
        case GestureType::GestureType_RotateMinusY: NN_LOG("RotateMinusY : "); break;
        case GestureType::GestureType_RotateMinusZ: NN_LOG("RotateMinusZ : "); break;
        case GestureType::GestureType_Throw:        NN_LOG("Throw        : "); break;
        case GestureType::GestureType_PushPlusX:    NN_LOG("PushPlusX    : "); break;
        case GestureType::GestureType_PushPlusY:    NN_LOG("PushPlusY    : "); break;
        case GestureType::GestureType_PushPlusZ:    NN_LOG("PushPlusZ    : "); break;
        case GestureType::GestureType_PushMinusX:   NN_LOG("PushMinusX   : "); break;
        case GestureType::GestureType_PushMinusY:   NN_LOG("PushMinusY   : "); break;
        case GestureType::GestureType_PushMinusZ:   NN_LOG("PushMinusZ   : "); break;
        case GestureType::GestureType_Spin:         NN_LOG("Spin         : "); break;

        default:                                    NN_LOG("Unregistered : "); break;
        }
        NN_LOG("%lld, %lld\n"
            , gestureState.samplingNumber
            , gestureState.gestureSamplingNumber);
    }
} // namespace
JoyDualSixAxisSensor::JoyDualSixAxisSensor(const nn::hid::NpadIdType& id) NN_NOEXCEPT
    : INpadStyleSixAxisSensor(id, nn::hid::NpadStyleJoyDual::Mask)
    , m_GestureSamplingNumber(0)
{
    m_SixAxisSensorGestureProcessor.Initialize();
}

void JoyDualSixAxisSensor::Update() NN_NOEXCEPT
{
    // ボタンの状態を更新します
    m_Buttons[1] = m_Buttons[0];
    nn::hid::NpadJoyDualState state;
    nn::hid::GetNpadState(&state, m_Id);
    m_Buttons[0] = state.buttons;

    auto index = 0; // 左
    m_SixAxisSensorGestureProcessor.Update(m_SixAxisSensorStates[index][0]);

    // m_SixAxisSensorGestureProcessor.Print();
    GestureState states[GestureStateCountMax];
    auto count = m_SixAxisSensorGestureProcessor.GetGestures(states, GestureStateCountMax);
    if (count > 0 &&
        m_GestureSamplingNumber < states[0].gestureSamplingNumber)
    {
        PrintGesture(states[0]);
        m_GestureSamplingNumber = states[0].gestureSamplingNumber;
    }

    // 6 軸センサーの状態を更新します
    UpdateSixAxisSensor();
}

bool JoyDualSixAxisSensor::IsConnected() const NN_NOEXCEPT
{
    // 現在有効な操作形態(NpadStyleSet)を取得
    nn::hid::NpadStyleSet style = nn::hid::GetNpadStyleSet(m_Id);

    return style.Test<nn::hid::NpadStyleJoyDual>();
}
