﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <cstdlib>
#include <string>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/os.h>

#include <nn/hid.h>
#include <nn/hid/hid_ControllerSupport.h>
#include <nn/hid/hid_ResultControllerSupport.h>
#include <nn/hid/hid_NpadJoyCommon.h>
#include <nn/swkbd/swkbd_Api.h>
#include <nn/err.h>
#include <nn/account.h>


#include "GraphicsSystem.h"
#include "FontSystem.h"
#include "Color.h"
#include "Npad.h"
#include "ApplicationHeap.h"
#include "Gesture.h"

namespace frm {

    // スレッド状態をGETするAPIが存在しない為、例外的にexternする
    extern nn::os::ThreadType thred;

    struct DrawPotition
    {
        float         X = 1280.f;
        const float   Y = 30.f;
        const float   Width = 300.f;
        const float   Height = 200.f;
    };

    //!< ConsoleSixAxisSensor 向けの処理を記述したクラスです。
    class Applet
    {

    private:
        bool    f_enbl = false;

        bool    m_up = false;
        bool    m_down = false;
        bool    m_fix = false;
        int     m_menu = 0;

        uint8_t m_TwinkleCounter = 0;
        bool m_TwinkleSwitchFlag = false;

        int m_SwipeCounter         = 0;
        int m_SwipeCounterState    = 0;

        float m_DeltaX            = 0.f;

        DrawPotition m_DrawPotition;

        void UpdateTwinkleCounter();

        void UpdateSwipeCounter(int functionMenu);

    public:
        static Applet& GetInstance() NN_NOEXCEPT;

        void Initialize();

        void CountrollerSupportThred();

        void CountrollerSupportDisconnectThred();

        void AccountManagerThred();

        void SwKeyBoardThred();

        void ErrorViewerThred();

        void NullAccessThred();

        void ThredDestroy();

        void Control(frm::NpadState * npadState);

        void DrawControl(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, int functionMenu);
    };

    void CountrollerSupport(void * dummy);
    void CountrollerSupportDisconnect(void * dummy);
    void AccountManager(void * dummy);
    void SwKeyBoard(void * dummy);
    void ErrorViewer(void * dummy);
    void NullAccess(void * dummy);
}

#ifndef gApplet
#define gApplet (frm::Applet::GetInstance())
#endif
