﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
@brief
アプリのレイアウトを描画します
*/

#pragma once
#include <cstdlib>
#include <string>
#include <vector>
#include <nn/nn_Log.h>

#include <nn/oe/oe_ApplicationControlApis.h>
#include <nn/oe/oe_ApplicationControlTypes.h>

#include <nn/nn_Macro.h>
#include "Framework/GraphicsSystem.h"
#include "Framework/CursolControl.h"
#include "Framework/FontSystem.h"
#include "Framework/Gesture.h"
#include "Framework/Color.h"
#include "Framework/Npad.h"

#include "BleUtility.h"
#include "PalmaUtility.h"

namespace frm {

    class Layout
    {
    private:
        size_t m_npadIndexOld;
        size_t m_menuIndexOld;

    public:
        uint8_t m_FrameTwinkleCounter = 0;
        bool    m_FrameTwinkleSwitchFlag = false;
        int     m_smoothCounter = 0;
        int     m_menuSmoothCounter = 0;
        int     m_scaningCounter = 0;
        bool    m_scaningSwitchFlag = false;

        static Layout& GetInstance() NN_NOEXCEPT;

        void DrawDisplay(GraphicsSystem* pGraphicsSystem,
                         nn::gfx::util::DebugFontTextWriter * pTextWriter,
                         frm::NpadState* state,
                         frm::SixAxis* sixAxis,
                         util::PalmaController* palmaStatus,
                         util::BleState* bleState,
                         frm::CursolPosition cursol);

    private:
        // カーソル点滅用変数のカウント処理
        void UpdateFrameTwinkleCounter(void);
        // カーソル移動のスムージング処理
        void UpdateSmoothCounter(size_t npadIndex);
        // Menu移動のスムージング処理
        void UpdateMenuSmoothCounter(size_t menuIndex);
        // Scan中描画のスムージング処理
        void UpdateScaningCounter(void);
        // 画面全体の背景描画
        void DrawOverView(GraphicsSystem* pGraphicsSystem, nn::gfx::util::DebugFontTextWriter* pTextWriter) NN_NOEXCEPT;
        // Npad毎の各種情報描画
        void DrawControler(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::NpadState * npadState, frm::SixAxis * sixAxis, util::PalmaController * palmaState, frm::CursolPosition cursol);
        // Activity(Sound、RgbLed)の描画
        void DrawActivity(GraphicsSystem* pGraphicsSystem, nn::gfx::util::DebugFontTextWriter* pTextWriter, frm::CursolPosition cursol) NN_NOEXCEPT;
        // Activity内のSoundデータの描画
        void DrawSound(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol) NN_NOEXCEPT;

        void DrawLoadFile(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol);
        // Activity内のRgbLedデータの描画
        void DrawRgbLed(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol) NN_NOEXCEPT;
        // Sound書き込みを指定した時の内容選択画面の描画
        void DrawWriteSound(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol);
        // RgbLed書き込みを指定した時の内容選択画面の描画
        void DrawWriteRgbLed(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol);
        // Npadの状態(ID、Style及びボタン状態)の描画
        void DrawNpadState(GraphicsSystem* pGraphicsSystem, nn::gfx::util::DebugFontTextWriter* pTextWriter, frm::NpadState state, size_t drawPotiion) NN_NOEXCEPT;
        // コントローラ入力の状態の描画
        void DrawInputState(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::NpadState state, nn::hid::SixAxisSensorState sixAxisState, size_t drawPotiion) NN_NOEXCEPT;
        // コントローラ姿勢を示すオブジェクトの描画
        void DrawObject(GraphicsSystem * pGraphicsSystem, frm::NpadState state, nn::util::Vector4fType quatanion, size_t ViewportScissorIndex);
        // 選択項目の描画
        void DrawNpadMenu(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, int npadFunction, frm::CursolStatus status, size_t drawPotiion);

        void DrawResult(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, util::PalmaController palmaState, size_t drawPotiion);
        // BleScan中であるかの描画
        void DrawIsScaning(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, bool isScaning, bool isScaningSmartDevice);
        // Palma固有のステートの描画
        void DrawPalmaStatus(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, util::PalmaController palmaState, frm::NpadState state, size_t drawPotiion);

        void DrawNpadStartScan(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol, size_t index);
        // 選択項目にてWriteActivityを指定した時に表示する、項目選択の描画
        void DrawNpadWriteActivity(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol, size_t index);
        // 選択項目にてPlayActivityを指定した時に表示する、項目選択の描画
        void DrawNpadPlayActivity(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol, size_t index);
        // 選択項目にてCheckReservedを指定した時に表示する、項目選択の描画
        void DrawNpadCheckReserved(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol, size_t index);
        // 選択項目にてWriteDatabaseIdVerを指定した時に表示する、項目選択の描画
        void DrawNpadWriteDatabaseIdVer(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol, size_t index);
        // 選択項目にてSetFrModeを指定した時に表示する、項目選択の描画
        void DrawNpadSetFrMode(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol, size_t index);
        // 選択項目にてSuspendFeatureSetを指定した時に表示する、項目選択の描画
        void DrawNpadSuspendFeatureSet(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol, size_t index);
        // 選択項目にてSetBoostModeを指定した時に表示する、項目選択の描画
        void DrawNpadBoostMode(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol, size_t index);
        // ApplicationSection読み込みを指定した時に表示する項目の描画
        void DrawNpadReadAppData(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol, size_t index);
        // ApplicationSection書き込みを指定した時に表示する項目の描画
        void DrawNpadWriteAppData(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol, size_t index);
        // PlayLog読み込み、リセットを指定した時に表示する項目の描画
        void DrawNpadPlayLog(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, frm::CursolPosition cursol, size_t index);

        void DrawGattInfomation(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, util::BleState * state);
    };
}

#ifndef gLayout
#define gLayout (frm::Layout::GetInstance())
#endif
