﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "NpadController.h"
#include "IScene.h"
#include "LineChart.h"
#include "VectorChart.h"

class SceneSixAxisSensor final : public IScene
{
    NN_DISALLOW_COPY(SceneSixAxisSensor);
    NN_DISALLOW_MOVE(SceneSixAxisSensor);

private:
    LineChart m_LineChartAcceleration;
    LineChart m_LineChartAngularVelocity;
    VectorChart m_VectorChartAcceleration;
    VectorChart m_VectorChartAngle;
    NpadControllerList* m_pControllers;

    bool m_IsMenuLocked;

public:
    SceneSixAxisSensor() NN_NOEXCEPT;
    virtual ~SceneSixAxisSensor() NN_NOEXCEPT NN_OVERRIDE { /* 何もしない */ };
    virtual void OnSceneFocused() NN_NOEXCEPT NN_OVERRIDE;
    void SetNpadControllerList(NpadControllerList* pControllers) NN_NOEXCEPT;
    virtual PackedButton Control(const PackedButton& button) NN_NOEXCEPT NN_OVERRIDE;

protected:
    virtual void DrawImpl(RecordablePosition& position) NN_NOEXCEPT NN_OVERRIDE;
    virtual std::string GetGuideString() NN_NOEXCEPT NN_OVERRIDE
    {
        if (m_IsMenuLocked)
        {
            return "\uE0ED/\uE0EE Num of Samples   \uE0EB/\uE0EC Zoom   \uE0E2/\uE0E3 Shift YAxis   \uE0E4/\uE0E5 Reset   \uE0EF/\uE0F0 Unlock";
        }
        return "\uE0EF/\uE0F0 Lock";
    }
    virtual std::string GetSceneName() NN_NOEXCEPT NN_OVERRIDE
    {
        return "Six Axis Sensor";
    }
};
