﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "IScene.h"
#include "PackedButton.h"

//------------------------------------------------------------------------------
//  Scene の制御
//------------------------------------------------------------------------------
class SceneManager
{
    NN_DISALLOW_COPY(SceneManager);
    NN_DISALLOW_MOVE(SceneManager);

private:
    std::vector<IScene*> m_pScenes;
    int m_SelectedScene;

public:
    SceneManager() NN_NOEXCEPT :
        m_SelectedScene(0)
    {
        // 何もしない
    };

    void Add(IScene* pScene) NN_NOEXCEPT;
    void Draw() NN_NOEXCEPT;
    void DrawHeader() NN_NOEXCEPT;
    PackedButton Control(const PackedButton& button) NN_NOEXCEPT;

private:
    IScene* GetCurrentScene() NN_NOEXCEPT;
};
