﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_TFormatString.h>

#include "LogPrint.h"
#include "TimeUtil.h"

namespace {

LogRingBuffer g_Buffer;

} // namespase

void PrintLog(bool warn, const char* format, ...) NN_NOEXCEPT
{
    PackedLog temp;
    std::va_list args;
    va_start(args, format);
    nn::util::VSNPrintf(temp.log, sizeof(temp.log), format, args);
    va_end(args);

    temp.isWarn = warn;
    GetCurrentCalenderTime(&temp.time);
    NN_LOG("[TestTool:%04d/%02d/%02d %02d:%02d:%02d] %s\n",
        temp.time.year, temp.time.month, temp.time.day, temp.time.hour, temp.time.minute, temp.time.second,
        temp.log);
    g_Buffer.push_back(temp);
}

const LogRingBuffer& GetLogs() NN_NOEXCEPT
{
    return g_Buffer;
}
