﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Common.h>
#include <nn/util/util_MathTypes.h>

#include "s2d/Simple2D.h"

class ILineChartDataSetAccessor
{
protected:
    std::string m_Label;
    s2d::Color m_Color;

public:
    virtual int size() NN_NOEXCEPT = 0;
    virtual float at(int index) NN_NOEXCEPT = 0;
    virtual const char* backStr(char* buf) NN_NOEXCEPT = 0;
    virtual const char* maxStr(char* buf) NN_NOEXCEPT = 0;
    virtual const char* minStr(char* buf) NN_NOEXCEPT = 0;
    s2d::Color color() NN_NOEXCEPT
    {
        return m_Color;
    }
    const char* label() NN_NOEXCEPT
    {
        return m_Label.c_str();
    }
};

const int LineChartUiParametCount = 3;

struct LineChartUiParameterConfig
{
    float init;
    float max;
    float min;
    float step;
};

struct LineChartUiParameterConfigList
{
    union
    {
        LineChartUiParameterConfig v[LineChartUiParametCount];
        struct
        {
            LineChartUiParameterConfig xSampleCount;
            LineChartUiParameterConfig yScale;
            LineChartUiParameterConfig yShift;
        };
    };
};


class LineChart
{
public:
    enum UiParameterType
    {
        UiParameterType_XSampleCount,
        UiParameterType_YScale,
        UiParameterType_YShift,
    };

private:
    LineChartUiParameterConfigList m_UiParameterConfig;
    float        m_UiParameter[LineChartUiParametCount];
    float        m_Range;           // 表示する値の幅
    float        m_YGridUnit;       // 補助線を表示する単位
    int          m_SampleCountMax;  // 表示するサンプル数

    bool         m_YInFloat;        // Y軸を Float で扱うかどうか

public:
    LineChart(const LineChartUiParameterConfigList& config, bool yInFloat) NN_NOEXCEPT;
    void Increment(UiParameterType param) NN_NOEXCEPT;
    void Decrement(UiParameterType param) NN_NOEXCEPT;
    void Draw(s2d::Point2D position,
              s2d::Size    size,
              bool plot,
              ILineChartDataSetAccessor* pDataSets[],
              int count) NN_NOEXCEPT;


private:
    void DrawFrame(s2d::Point2D position,
                   s2d::Size    size) NN_NOEXCEPT;
    void DrawSamples(s2d::Point2D position,
                     s2d::Size    size,
                     bool plot,
                     ILineChartDataSetAccessor* pDataSets[],
                     int count) NN_NOEXCEPT;
    void DrawValue(s2d::Point2D position,
                   s2d::Size    size,
                   ILineChartDataSetAccessor* pDataSets[],
                   int count) NN_NOEXCEPT;

    void UpdateUiParameter() NN_NOEXCEPT;
};
