﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <cstdlib>
#include <string>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/hid.h>
#include <nn/hid/hid_SevenSixAxisSensor.h>
#include <nn/hid/debug/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/debug/hid_SevenSixAxisSensor.h>
#include <nn/hid/hid_SixAxisSensor.h>
#include <nn/hid/hid_NpadSixAxisSensor.h>
#include <nn/util/util_Quaternion.h>
#include <nn/util/util_BitFlagSet.h>
#include <nn/util/util_MathTypes.h>

#include "frm_Npad.h"

namespace frm { namespace hid {

    //!< NPadの状態をひとまとめにした構造体定義
    struct SixAxisState
    {
        bool                    isRest;                 //!< 静止状態(TRUE：静止)
        int64_t                 samplingNum;            //!< サンプリング値
        int64_t                 samplingNumPrev;        //!< サンプリング前回値
        int64_t                 samplingFreq;           //!< サンプリング周波数
        int64_t                 coordinationNum;        //!< 基準姿勢が変わる度に増加する値です。
        nn::util::Float3        acceleration;           //!< 各方向ごとの加速度[G]
        nn::util::Float3        angularVelocity;        //!< 各方向ごとの角速度[1/360dps]
        nn::util::Float3        angle;                  //!< 回転角[1/360度]
        nn::util::Quaternion    quaternion;             //!< クオータニオン
        int                     samplingCount;          //!< サンプリングカウント数
        nn::TimeSpanType        timeStamp;
    };

    class NpadSixAxisSns
    {

    private:
        nn::hid::SixAxisSensorHandle            m_Handle;     //!< ハンドル

    public:
        static NpadSixAxisSns& GetInstance() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;

        void GetInitialValue(SixAxisState * pState);

        void GetState(SixAxisState* st) NN_NOEXCEPT;

        bool Start(SixAxisState* st) NN_NOEXCEPT;
        bool Stop(SixAxisState* st) NN_NOEXCEPT;
    };

    //!< SevenSixAxisSensor 向けの処理を記述したクラスです。
    class SevenSixAxisSns
    {
    private:
        NN_ALIGNAS(0x1000) uint8_t      m_WorkBuffer[::nn::hid::SevenSixAxisSensorWorkBufferSize];
        nn::Result                      m_SevenSixAxisStartResult;

    public:
        static SevenSixAxisSns& GetInstance() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;
        void GetInitialValue(SixAxisState * pState);
        void Finalize() NN_NOEXCEPT;
        void GetState(SixAxisState* st) NN_NOEXCEPT;

        bool Start() NN_NOEXCEPT;
        bool Stop() NN_NOEXCEPT;
        void GetSamplingFreq(SixAxisState * st);
    };
}} // namespace frm::hid

#ifndef gSevenSixAxisSns
#define gSevenSixAxisSns (frm::hid::SevenSixAxisSns::GetInstance())
#endif

#ifndef gNpadSixAxisSns
#define gNpadSixAxisSns (frm::hid::NpadSixAxisSns::GetInstance())
#endif
