﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "frm_SixAxis.h"

namespace frm { namespace hid {

    /* Singleton パターン */
    SevenSixAxisSns& SevenSixAxisSns::GetInstance() NN_NOEXCEPT
    {
        static SevenSixAxisSns Instance;
        return Instance;
    }

    NpadSixAxisSns& NpadSixAxisSns::GetInstance() NN_NOEXCEPT
    {
        static NpadSixAxisSns Instance;
        return Instance;
    }

    /* ------------------------------------------------------------ */
    // PRIVATE関数
    /* ------------------------------------------------------------ */

    /* ------------------------------------------------------------ */
    // PUBLIC関数
    /* ------------------------------------------------------------ */

    /*---------------*/
    /* NPad6軸センサ */
    /*---------------*/
    void NpadSixAxisSns::Initialize() NN_NOEXCEPT
    {
        // Npad6軸センサのハンドルを取得
        NN_LOG("ハンドル数 = %d\n",nn::hid::GetSixAxisSensorHandles(&m_Handle, 1, NpadIds[8], nn::hid::NpadStyleHandheld::Mask));
    }

    void NpadSixAxisSns::GetInitialValue(SixAxisState* pState) NN_NOEXCEPT
    {
        pState->samplingNum = 0;
        pState->samplingNumPrev = 0;
        pState->coordinationNum = 0;
        pState->acceleration.x = 0.f;
        pState->acceleration.y = 0.f;
        pState->acceleration.z = 0.f;
        pState->angularVelocity.x = 0.f;
        pState->angularVelocity.y = 0.f;
        pState->angularVelocity.z = 0.f;
        pState->angle.x = 0.f;
        pState->angle.y = 0.f;
        pState->angle.z = 0.f;
        pState->isRest = false;
        pState ->quaternion = nn::util::Quaternion::Identity();
        pState ->samplingFreq = 0;
        pState->samplingCount = 0;
        pState->timeStamp._nanoSeconds = 0;
    }

    void NpadSixAxisSns::GetState(SixAxisState* pState) NN_NOEXCEPT
    {
        nn::hid::SixAxisSensorState sensorState[nn::hid::SixAxisSensorStateCountMax];

        // 本体6軸センササンプリング値の取得
        pState->samplingCount = nn::hid::GetSixAxisSensorStates(sensorState, nn::hid::SixAxisSensorStateCountMax, m_Handle);

        //for (auto i = 0; i < nn::hid::SixAxisSensorStateCountMax; i++)
        //{
        //    if (i == 2)
        //    {
        //        NN_LOG("..........間引き...........\n");
        //        i = nn::hid::SixAxisSensorStateCountMax - 2;
        //    }
        //    NN_LOG("Old[%d][ACCL] >> (%.3f, %.3f, %.3f)    [RATE] >> (%.3f, %.3f, %.3f)\n", i,
        //                                                                                 sensorState[i].acceleration.x,
        //                                                                                 sensorState[i].acceleration.y,
        //                                                                                 sensorState[i].acceleration.z,
        //                                                                                 sensorState[i].angularVelocity.x,
        //                                                                                 sensorState[i].angularVelocity.y,
        //                                                                                 sensorState[i].angularVelocity.z);
        //}
        //NN_LOG("\n");

        if (pState->samplingCount != 0)
        {
            pState->samplingNum = sensorState[0].samplingNumber;

            pState->acceleration = sensorState[0].acceleration;
            pState->angularVelocity = sensorState[0].angularVelocity;
            pState->angle = sensorState[0].angle;

            pState->timeStamp = sensorState[0].deltaTime;

            sensorState[0].GetQuaternion(&(pState->quaternion));

            pState->isRest = IsSixAxisSensorAtRest(m_Handle);
        }
    }

    bool NpadSixAxisSns::Start(SixAxisState* st) NN_NOEXCEPT
    {
        nn::hid::StartSixAxisSensor(m_Handle);

        return true;
    }

    bool NpadSixAxisSns::Stop(SixAxisState* st) NN_NOEXCEPT
    {
        nn::hid::StopSixAxisSensor(m_Handle);

        return false;
    }

    /*-------------------*/
    /* 本体6軸センサ     */
    /*-------------------*/
    void SevenSixAxisSns::Initialize() NN_NOEXCEPT
    {
        // 本体6軸センサの初期化処理
        nn::hid::InitializeSevenSixAxisSensor(m_WorkBuffer, nn::hid::SevenSixAxisSensorWorkBufferSize);
        // 念のためStop()を行う
        nn::hid::StopSevenSixAxisSensor();
    }

    void SevenSixAxisSns::GetInitialValue(SixAxisState* pState) NN_NOEXCEPT
    {
        pState->samplingNum = 0;
        pState->samplingNumPrev = 0;
        pState->coordinationNum = 0;
        pState->acceleration.x = 0.f;
        pState->acceleration.y = 0.f;
        pState->acceleration.z = 0.f;
        pState->angularVelocity.x = 0.f;
        pState->angularVelocity.y = 0.f;
        pState->angularVelocity.z = 0.f;
        pState->angle.x = 0.f;
        pState->angle.y = 0.f;
        pState->angle.z = 0.f;
        pState->isRest = false;
        pState->quaternion = nn::util::Quaternion::Identity();
        pState->samplingFreq = 0;
        pState->samplingCount = 0;
        pState->timeStamp._nanoSeconds = 0;
    }

    void SevenSixAxisSns::Finalize() NN_NOEXCEPT
    {
        ::nn::hid::FinalizeSevenSixAxisSensor();
    }

    bool SevenSixAxisSns::Start() NN_NOEXCEPT
    {
        nn::hid::StartSevenSixAxisSensor();

        return true;
    }

    void SevenSixAxisSns::GetState(SixAxisState* pState) NN_NOEXCEPT
    {
        nn::hid::SevenSixAxisSensorState sensorState[nn::hid::SevenSixAxisSensorStateCountMax];

        // 本体6軸センササンプリング値の取得
        pState->samplingCount = nn::hid::GetSevenSixAxisSensorStates(sensorState, nn::hid::SevenSixAxisSensorStateCountMax);

        //for (auto i = 0; i < nn::hid::SevenSixAxisSensorStateCountMax; i++)
        //{
        //    if (i == 2)
        //    {
        //        NN_LOG("..........間引き...........\n");
        //        i = nn::hid::SevenSixAxisSensorStateCountMax - 2;
        //    }
        //    NN_LOG("New[%d][ACCL] >> (%.3f, %.3f, %.3f)    [RATE] >> (%.3f, %.3f, %.3f)\n", i,
        //           sensorState[i].acceleration.x,
        //           sensorState[i].acceleration.y,
        //           sensorState[i].acceleration.z,
        //           sensorState[i].angularVelocity.x,
        //           sensorState[i].angularVelocity.y,
        //           sensorState[i].angularVelocity.z);
        //}
        //NN_LOG("\n");

        if (pState->samplingCount != 0)
        {
            pState->samplingNum = sensorState[0].samplingNumber;
            pState->coordinationNum = sensorState[0].coordinateNumber;

            pState->acceleration = sensorState[0].acceleration;
            pState->angularVelocity = sensorState[0].angularVelocity;

            pState->timeStamp = sensorState[0].timeStamp;

            pState->quaternion = sensorState[0].rotation;

            pState->isRest = nn::hid::IsSevenSixAxisSensorAtRest();
        }
    }

    bool SevenSixAxisSns::Stop() NN_NOEXCEPT
    {
        nn::hid::StopSevenSixAxisSensor();

        return false;
    }

    void SevenSixAxisSns::GetSamplingFreq(SixAxisState* pState)
    {
        pState->samplingFreq = ::nn::hid::debug::GetConsoleSixAxisSensorSamplingFrequency();
    }
}} // namespace frm::hid
