﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
    @brief
    本体姿勢を簡易図形描画します。
*/

#include "Main_DrawCube.h"

namespace main{

    const int FrameBufferWidth = 1280;
    const int FrameBufferHeight = 720;

    void DrawCube::Draw(GraphicsSystem* pGraphicsSystem, nn::util::Quaternion relQuat, size_t ViewportScissorIndex) NN_NOEXCEPT
    {
        nn::gfx::ViewportScissorState* pViewportScissorState = &pGraphicsSystem->GetViewportScissor(ViewportScissorIndex);
        pGraphicsSystem->GetCommandBuffer().SetViewportScissorState(pViewportScissorState);

        nn::util::Vector3fType center = { 0.f, 0.f, 0.f };
        nn::util::Vector3fType size = { 3.0f, 1.5f, 0.8f };

        nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer = &pGraphicsSystem->GetPrimitiveRenderer();

        nn::util::Matrix4x3fType viewMatrix;
        nn::util::Matrix4x4fType projectionMatrix;
        nn::util::Matrix4x3f modelMatrix;

        nn::util::Vector3fType cameraPosition = { 0.0f, 0.0f, 3.f };
        nn::util::Vector3fType cameraTarget = { 0.f, 0.f, 0.f };
        nn::util::Vector3fType cammeraUp = { 0.f, 1.f, 0.f };
        nn::util::MatrixLookAtRightHanded(&viewMatrix, cameraPosition, cameraTarget, cammeraUp);
        pPrimitiveRenderer->SetViewMatrix(&viewMatrix);

        pPrimitiveRenderer->SetLineWidth(2.f);

        // プロジェクションを初期化
        const float Fovy = nn::util::FloatPi / 3.0f;
        const float Aspect = static_cast< float >(FrameBufferWidth) / static_cast< float >(FrameBufferHeight);
        nn::util::MatrixPerspectiveFieldOfViewRightHanded(&projectionMatrix, Fovy, Aspect, 0.1f, 100.f);
        pPrimitiveRenderer->SetProjectionMatrix(&projectionMatrix);

        nn::util::Vector3f vecZero;
        nn::util::VectorZero(&vecZero);

        modelMatrix = nn::util::MatrixRowMajor4x3f::MakeRotation(relQuat);
        nn::util::MatrixSetAxisW(&modelMatrix, vecZero);
        pPrimitiveRenderer->SetModelMatrix(&modelMatrix);

        // 3D描画(深度テスト)の有効化
        nns::gfx::PrimitiveRenderer::DepthStencilType info = nns::gfx::PrimitiveRenderer::DepthStencilType::DepthStencilType_DepthWriteTest;

        if (ViewportScissorIndex == 1)
        {
            pPrimitiveRenderer->SetColor(Color::Orange);
        }
        else
        {
            pPrimitiveRenderer->SetColor(Color::Violet);
        }
        pGraphicsSystem->GetPrimitiveRenderer().DrawCube(&pGraphicsSystem->GetCommandBuffer(), nns::gfx::PrimitiveRenderer::Surface_Wired, center, size);

        if (ViewportScissorIndex == 1)
        {
            pPrimitiveRenderer->SetColor(HalfColor::Orange);
        }
        else
        {
            pPrimitiveRenderer->SetColor(HalfColor::Violet);
        }
        pGraphicsSystem->GetPrimitiveRenderer().DrawCube(&pGraphicsSystem->GetCommandBuffer(), nns::gfx::PrimitiveRenderer::Surface_Normal, center, size);

        // 3D描画(深度テスト)の再無効化
        info = nns::gfx::PrimitiveRenderer::DepthStencilType::DepthStencilType_DepthNoWriteTest;
        pGraphicsSystem->GetPrimitiveRenderer().SetDepthStencilState(&pGraphicsSystem->GetCommandBuffer(), info);

        pViewportScissorState = &pGraphicsSystem->GetViewportScissor(0);
        pGraphicsSystem->GetCommandBuffer().SetViewportScissorState(pViewportScissorState);

        // レンダラの各パラメータ初期化
        pPrimitiveRenderer->SetDefaultParameters();
    }
}
// [EOF]
