﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/hid/hid_NpadJoyDual.h>

#include "INpadStyleSixAxisSensor.h"

//!< NpadStyleJoyDual 操作形態向けの処理を記述したクラスです。
class JoyDualSixAxisSensor : public INpadStyleSixAxisSensor
{
    NN_DISALLOW_COPY(JoyDualSixAxisSensor);
    NN_DISALLOW_MOVE(JoyDualSixAxisSensor);

public:
    explicit JoyDualSixAxisSensor(const nn::hid::NpadIdType& id) NN_NOEXCEPT;

    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;

    virtual bool IsConnected() const NN_NOEXCEPT NN_OVERRIDE;
};

