﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_TimeSpan.h>
#include <nn/hid/hid_Xpad.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nnt/nntest.h>

#if defined(NN_BUILD_CONFIG_TOOLCHAIN_CLANG)
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

#if defined(NN_BUILD_CONFIG_TOOLCHAIN_GCC)
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

#if defined(NN_BUILD_CONFIG_TOOLCHAIN_VC)
#pragma warning(disable:4996)
#endif

//!< Xpad ID の再解決通知のバインド状態が正しく管理されているか
TEST(XpadEventSuite, BindTest1)
{
    auto event1 = ::nn::os::SystemEventType();
    auto event2 = ::nn::os::SystemEventType();

    ::nn::hid::BindXpadIdEvent(&event1, ::nn::os::EventClearMode_AutoClear);

    // 重複してバインドはできない
    EXPECT_DEATH_IF_SUPPORTED(
        ::nn::hid::BindXpadIdEvent(&event1, ::nn::os::EventClearMode_AutoClear),
        "");

    // 同時に複数のイベントに対してバインドできない
    EXPECT_DEATH_IF_SUPPORTED(
        ::nn::hid::BindXpadIdEvent(&event2, ::nn::os::EventClearMode_AutoClear),
        "");

    // バインド対象でないイベントに対しては何も行わない
    ::nn::hid::UnbindXpadIdEvent(&event2);

    ::nn::hid::UnbindXpadIdEvent(&event1);

    // 一度アンバウンドすれば再バウンド可能
    ::nn::hid::BindXpadIdEvent(&event2, ::nn::os::EventClearMode_AutoClear);

    ::nn::hid::UnbindXpadIdEvent(&event2);
}

//!< バインド直後の Xpad ID の再解決通知はシグナルされているか
TEST(XpadEventSuite, SignalTest1)
{
    auto event = ::nn::os::SystemEventType();

    ::nn::hid::BindXpadIdEvent(&event, ::nn::os::EventClearMode_AutoClear);

    EXPECT_TRUE(::nn::os::TryWaitSystemEvent(&event));

    ::nn::hid::UnbindXpadIdEvent(&event);
}
