﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/system/hid_Npad.h>
#include <nn/hid/hid_Result.h>
#include <nn/hid/hid_ResultController.h>
#include <nnt/nntest.h>

#include "testHid_NpadCommon.h"
#include "../Common/testHid_Npad.h"

namespace {

struct PlayerLedTestPattern
{
    nn::hid::NpadIdType id;
    nn::Bit8 pattern;
};

PlayerLedTestPattern playerLedTestPatterns[] = {
    {nn::hid::NpadId::No1, 0x01},
    {nn::hid::NpadId::No2, 0x03},
    {nn::hid::NpadId::No3, 0x07},
    {nn::hid::NpadId::No4, 0x0f},
    {nn::hid::NpadId::No5, 0x09},
    {nn::hid::NpadId::No6, 0x05},
    {nn::hid::NpadId::No7, 0x0D},
    {nn::hid::NpadId::No8, 0x06},
    {nn::hid::NpadId::Handheld, 0x00},
};

}

//!< プレイヤーパターンの取得され値のチェック
TEST(NpadPlayerLed, FullPattern)
{
    for (auto& testPattern : playerLedTestPatterns)
    {
        auto pattern = ::nn::hid::GetPlayerLedPattern(testPattern.id);
        EXPECT_EQ(testPattern.pattern, pattern);
    }
}
