﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/hid/hid_Npad.h>
#include <nn/hid/system/hid_Nfc.h>
#include <nn/hid/debug/hid_Npad.h>
#include <nn/os.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nnt/nntest.h>

nn::hid::NpadIdType g_NpadIds[] = {
    nn::hid::NpadId::No1,
    nn::hid::NpadId::No2,
    nn::hid::NpadId::No3,
    nn::hid::NpadId::No4,
    nn::hid::NpadId::No5,
    nn::hid::NpadId::No6,
    nn::hid::NpadId::No7,
    nn::hid::NpadId::No8,
    nn::hid::NpadId::Handheld,
};

//!< 各APIの呼び出しに成功するか
TEST(NfcListDevice, NfcListDeviceTest)
{
    nn::os::SystemEventType systemEvent;

    nn::hid::InitializeNpad();

    nn::hid::system::BindNfcDeviceUpdateEvent(&systemEvent, nn::os::EventClearMode_AutoClear);

    nn::os::WaitSystemEvent(&systemEvent);

    const int NpadIdCountMax = 10;
    int expectedCount = 0;
    nn::hid::NpadIdType npadIds[NpadIdCountMax];
    for (auto& npadId : g_NpadIds)
    {
        nn::xcd::DeviceHandle xcdHandle;
        EXPECT_FALSE(nn::hid::system::IsNfcActivated(npadId));

        if(nn::hid::system::GetXcdHandleForNpadWithNfc(&xcdHandle, npadId).IsSuccess())
        {
            EXPECT_TRUE(nn::hid::system::ActivateNfc(npadId).IsSuccess());
            EXPECT_TRUE(nn::hid::system::IsNfcActivated(npadId));
            EXPECT_TRUE(nn::hid::system::DeactivateNfc(npadId).IsSuccess());
            EXPECT_FALSE(nn::hid::system::IsNfcActivated(npadId));
            ++expectedCount;
        }
        else
        {
            EXPECT_FALSE(nn::hid::system::ActivateNfc(npadId).IsSuccess());
            EXPECT_FALSE(nn::hid::system::DeactivateNfc(npadId).IsSuccess());
        }
    }
    EXPECT_EQ(nn::hid::system::GetNpadsWithNfc(npadIds, NpadIdCountMax), expectedCount);

    nn::hid::debug::FinalizeNpad();
}
